import gtk
import hildondesktop
import cairo
import gobject
import pango
import commands
import traceback
import re
import datetime
import sys
from ConfigParser import *

supports_alpha = False

class IPPlugin(hildondesktop.HomeItem):
	def __init__(self):
		hildondesktop.HomeItem.__init__(self)
		
		if(int(self._prefRead('autosize'))==1):
			self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
		else:
			self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_NONE)

		self.connect("settings", self._DoSettings)

		self.label = gtk.Label()
		self.label.set_use_markup(True)
		self.label.modify_font(pango.FontDescription (self._prefRead('font')))
		self.label.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._prefRead('background')))
		self.label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._prefRead('foreground')))
		self.label.set_text(self.get_text())
		self.label.set_padding(15, 10)
#		self.label.set_padding(-1, -1)
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.inbackground = False

		self.connect("expose-event", self.expose)
		self.connect("screen-changed", self.screen_changed)
		self.add(self.label)
		self.show_all()

		# set a timeout to change the images
		self.timer = gobject.timeout_add(60000, self.update)
#		print "foreground timer", self.timer

		self.connect ("background", self.background)
		self.connect ("foreground", self.foreground)

	def _DoSettings(self,widget,data=None):
		menuitem = gtk.MenuItem("HomeIP")
		menuitem.connect_object("activate", self._ShowSettings,None)
		return menuitem
	
	def _color_to_string(self,c):
		t = "#"
		
		if len(hex(c.red)[2:4])==1:
			t = t+'0'+hex(c.red)[2:4]
		else:
			t = t+hex(c.red)[2:4]
		if len(hex(c.green)[2:4])==1:
			t = t+'0'+hex(c.green)[2:4]
		else:
			t = t+hex(c.green)[2:4]
		if len(hex(c.blue)[2:4])==1:
			t = t+'0'+hex(c.blue)[2:4]
		else:
			t = t+hex(c.blue)[2:4]
		return t
		
	def _validate(self,widget,*data):
#		print self._widgetTree.get_widget("color_background").get_current_color()
		self._prefSave('background',self._color_to_string(self._widgetTree.get_widget("color_background").get_current_color()))
		self._prefSave('foreground',self._color_to_string(self._widgetTree.get_widget("color_foreground").get_current_color()))
		self._prefSave('background_alpha',str(self._widgetTree.get_widget("color_background").get_current_alpha()))
		self._prefSave('foreground_alpha',str(self._widgetTree.get_widget("color_foreground").get_current_alpha()))
		self._prefSave('font',self._widgetTree.get_widget("fontselection").get_font_name())
		self._prefSave('autosize',str(int(self._widgetTree.get_widget("bautosize").get_active())))
		self._window.destroy()
		
	def _cancel(self,widget,*data):
		self._window.destroy()
		
	def _closebox(self,widget,*data):
		self._window.destroy()
		
	def _prefRead(self,key):
		default = {'background':'#000000','background_alpha':'32767','foreground':'#FFFFFF','foreground_alpha':'255','font':'Sans 16','autosize':'1'}
		c = ConfigParser(default)
		c.read('/home/user/.homeip')
		print key+':'+str(c.get("DEFAULT", key))
		return c.get("DEFAULT", key)

	def _prefSave(self,key,value):
		print str(key) + ':' + str(value)
		default = {'background':'#000000','background_alpha':'32767','foreground':'#FFFFFF','foreground_alpha':'255t','font':'Sans 16','autosize':'1'}
		c = ConfigParser(default)
		c.read('/home/user/.homeip')
		c.set('DEFAULT',key,value)
		fp = open('/home/user/.homeip','w')
		c.write(fp)
		fp.close()
		
	def _ShowSettings(self,widget,data=None):
		import gtk.glade
		self._widgetTree = gtk.glade.XML('/usr/lib/homeip/prefs.glade')
		self._window = self._widgetTree.get_widget("prefs")
		self._widgetTree.get_widget("color_background").set_current_color(gtk.gdk.color_parse(self._prefRead('background')))
		self._widgetTree.get_widget("color_background").set_has_opacity_control(True)
		self._widgetTree.get_widget("color_background").set_current_alpha(int(self._prefRead('background_alpha')))
		self._widgetTree.get_widget("color_foreground").set_current_color(gtk.gdk.color_parse(self._prefRead('foreground')))
		self._widgetTree.get_widget("color_foreground").set_current_alpha(int(self._prefRead('foreground_alpha')))
		self._widgetTree.get_widget("color_foreground").set_has_opacity_control(True)
		self._widgetTree.get_widget("fontselection").set_font_name(self._prefRead('font'))
		self._widgetTree.get_widget("bautosize").set_active(int(self._prefRead('autosize')))


		callbackMapping = {
			# Signal
		  "on_bCancel_clicked": self._cancel,
		  "on_bValidate_clicked": self._validate,
		}
		self._widgetTree.signal_autoconnect(callbackMapping)
		self._window.connect("delete-event", self._closebox)
		
		self._window.show()
		
		return True
		
	def expose(self, widget, event):
		cr = self.window.cairo_create()
		if supports_alpha == True:
			cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent
		else:
			cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

		# Draw the background
		cr.set_operator(cairo.OPERATOR_SOURCE)
		cr.paint()

		# draw rounded rect
		width, height = self.allocation[2], self.allocation[3]

		#/* a custom shape, that could be wrapped in a function */
		x0 = 0   #/*< parameters like cairo_rectangle */
		y0 = 0

		radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

		x1 = x0 + width
		y1 = y0 + height

		cr.move_to  (x0, y0 + radius)
		cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
		cr.line_to (x1 - radius, y0)
		cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
		cr.line_to (x1 , y1 - radius)
		cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
		cr.line_to (x0 + radius, y1)
		cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

		cr.close_path ()
		
		bg_color=gtk.gdk.color_parse(self._prefRead('background'))

		cr.set_source_rgba (bg_color.red / 65535.0, bg_color.green/65535.0, bg_color.blue/65535.0, float(self._prefRead('background_alpha'))/65535.0)
		cr.fill_preserve ()
		# cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
		# cr.stroke ()

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = widget.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
#			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
#			print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		widget.set_colormap(colormap)

		return False

	def update(self):
		self.label.set_text(self.get_text())
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		#self.timer = gobject.timeout_add(2000, self.update)
		return not self.inbackground

	def background(self, widget, data=None):
		#Avoid refresh when applet is in background
		self.label.set_text("refreshing")
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.inbackground = True
		if self.timer != None:
			gobject.source_remove(self.timer)
			self.timer = None

	def foreground(self, widget, data=None):
		if(int(self._prefRead('autosize'))==1):
			self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
		else:
			self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_NONE)
			
		self.label.modify_font(pango.FontDescription (self._prefRead('font')))
		self.label.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._prefRead('background')))
		self.label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._prefRead('foreground')))
		self.label.set_text(self.get_text())
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.inbackground = False
		self.timer = gobject.timeout_add(60000, self.update)
#		print "foreground timer", self.timer

	def unrealize(self, widget, date=None):
		# cancel timeout
		v = gobject.source_remove(self.timer)
#		print "canceled homeip timeout:", v

	def get_text(self):
		text = "No IP"
		devs = commands.getoutput("/sbin/ifconfig wlan0")
		sdevs = devs.rsplit('\n')
		for stdev in sdevs:
			#sdev = re.findall("(\S*)\s*", stdev)
			if 'inet addr:' in stdev:
				sdev = stdev.rsplit(':')
				sdev2 = sdev[1].rsplit(' ')
				text= "IP: " + sdev2[0]

		if text == "No IP":
			devs = commands.getoutput("/sbin/ifconfig ppp0")
			sdevs = devs.rsplit('\n')
			for stdev in sdevs:
				#sdev = re.findall("(\S*)\s*", stdev)
				if 'inet addr:' in stdev:
					sdev = stdev.rsplit(':')
					sdev2 = sdev[1].rsplit(' ')
					text= "IP: " + sdev2[0]
		return text
		
def hd_plugin_get_objects():
	plugin = IPPlugin()
	return [plugin]

if __name__ == "__main__":
	print IPPlugin()
	print IPPlugin().update()
	print IPPlugin().get_text()
	print IPPlugin()._ShowSettings('a')
	gtk.main()
	