import gtk
import hildondesktop
import cairo
import gobject
import pango
import commands
import traceback
import datetime

DATE_FORMAT = "%x"
TIME_FORMAT = "%H:%M"
DAY_VIEW_FORMAT = "%H:%M"
WEEK_VIEW_FORMAT = "%H:%M"
MONTH_VIEW_FORMAT = "%H:%M"
FIRST_DAY_WEEK = 0

supports_alpha = False

def googleToDays(s):
  d = []
  if 'SU' in s:
    d.append(6)
  if 'MO' in s:
    d.append(0)
  if 'TU' in s:
    d.append(1)
  if 'WE' in s:
    d.append(2)
  if 'TH' in s:
    d.append(3)
  if 'FR' in s:
    d.append(4)
  if 'SA' in s:
    d.append(5)
  if 'SU' in s:
    d.append(6)

  if len(d)==0:
    d = [0,1,2,3,4,5,6]

  return d

def addMonth(date, n=1):
    # add n+1 months to date then subtract 1 day
    # to get eom, last day of target month
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month+n, 12)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def endMonth(d):
    d = d.replace(day=1)
    d = addMonth(d)
    diff = datetime.timedelta(days=1)
    d = d - diff
    debug(d)
    return d

def supMonth(date, n=1):
    # add n+1 months to date then subtract 1 day
    # to get eom, last day of target month
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month-n, 12)
    debug(date.year)
    debug(q)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def getWeekDetails(date):
  nb_day = date.weekday()
  diff = datetime.timedelta(days=nb_day)
  first_day = date - diff
  nb_day = 6 - date.weekday()
  diff = datetime.timedelta(days=nb_day)
  last_day = date + diff
  return (first_day,last_day)

class IPPlugin(hildondesktop.HomeItem):
	def __init__(self):
		hildondesktop.HomeItem.__init__(self)
		self.label = gtk.Label()
		self.label.set_use_markup(True)
		self.label.modify_font(pango.FontDescription ("Sans 16"))
		self.label.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#000"))
		self.label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#fff"))
		self.label.set_markup(self.get_text())
		self.label.set_padding(15, 10)
#		self.label.set_padding(-1, -1)
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)

		self.connect("expose-event", self.expose)
		self.connect("screen-changed", self.screen_changed)
		self.add(self.label)
		self.show_all()

		# set a timeout to change the images
		self.timer = gobject.timeout_add(3600000, self.update)
#		print "foreground timer", self.timer

		self.inbackground = False

		self.connect ("background", self.background)
		self.connect ("foreground", self.foreground)

	def expose(self, widget, event):
		cr = self.window.cairo_create()

		if supports_alpha == True:
			cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent
		else:
			cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

		# Draw the background
		cr.set_operator(cairo.OPERATOR_SOURCE)
		cr.paint()

		# draw rounded rect
		width, height = self.allocation[2], self.allocation[3]

		#/* a custom shape, that could be wrapped in a function */
		x0 = 0   #/*< parameters like cairo_rectangle */
		y0 = 0

		radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

		x1 = x0 + width
		y1 = y0 + height

		cr.move_to  (x0, y0 + radius)
		cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
		cr.line_to (x1 - radius, y0)
		cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
		cr.line_to (x1 , y1 - radius)
		cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
		cr.line_to (x0 + radius, y1)
		cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

		cr.close_path ()

		cr.set_source_rgba (0.0, 0.0, 0.0, 0.5)
		cr.fill_preserve ()
		# cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
		# cr.stroke ()

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = widget.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
#			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
#			print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		widget.set_colormap(colormap)

		return False

	def background(self, widget, data=None):
		#Avoid refresh when applet is in background
		self.label.set_text("refreshing")
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.inbackground = True
		if self.timer != None:
			gobject.source_remove(self.timer)
			self.timer = None

	def foreground(self, widget, data=None):
		self.label.set_markup(self.get_text())
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.inbackground = False
		self.timer = gobject.timeout_add(3600000, self.update)
#		print "foreground timer", self.timer

	def unrealize(self, widget, date=None):
		# cancel timeout
		v = gobject.source_remove(self.timer)
#		print "canceled homeip timeout:", v

	def update(self):
		self.label.set_markup(self.get_text())
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		#self.timer = gobject.timeout_add(2000, self.update)
		return not self.inbackground

	def get_text(self):
		import sqlite3
		import datetime

		try:

			self.view_datetime = datetime.datetime.now()

			text = "<b>Today "+self.view_datetime.strftime('%x')+"</b>"
			db = sqlite3.connect('/home/user/.mPIM/mcalendar.db')
			dbcur = db.cursor()

			where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
			where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
			#reccuring
#			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
#			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
#			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
#			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '

			where = where + ')'

			dbcur.execute('SELECT  start, end, description,uuid,repeat,repeatvalue,frequency,until,byday FROM events  '+where + '  AND description<>"DELETED" ORDER by start')       
			events = dbcur.fetchall()
			if len(events)==0:
			  text = text + '\nNo events'
			for event in events:
			  repeat = event[4]
			  repeatvalue = int(event[5])
			  frequency = event[6]
			  byday = event[8]
			  until = datetime.datetime.strptime(event[7],'%Y-%m-%d %H:%M')
			  start_datetime = datetime.datetime.strptime(event[0],'%Y-%m-%d %H:%M')
			  end_datetime = datetime.datetime.strptime(event[1],'%Y-%m-%d %H:%M')
			  if not repeat:
			    text = text + '\n'+ start_datetime.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			  else:
			    if frequency=="Day(s)":
			      diff = datetime.timedelta(days=repeatvalue)
			      d = start_datetime
			      while (d.date() <= until.date()) and (d.date() <= self.view_datetime.date()):
			        if (d.date() == self.view_datetime.date()) and (self.view_datetime.weekday() in googleToDays(byday)):
			  			  text = text +'\n'+ d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = d+diff
			    elif frequency=="Week(s)":
			      diff = datetime.timedelta(days=repeatvalue*7)
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
			          text = text +'\n'+ d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = d+diff
			    elif frequency=="Month(s)":
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if d.strftime("%W")==self.view_datetime.strftime("%W"):
			          text = text + '\n'+d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = addMonth(d,repeatvalue) 
			    elif frequency=="Year(s)":
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%W")==self.view_datetime.strftime("%W"))) and (self.view_datetime.weekday() in googleToDays(byday)):
			          text = text + '\n'+d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = addMonth(d,repeatvalue*12) 

			self.view_datetime = self.view_datetime + datetime.timedelta(days=1)

			where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
			where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
			#reccuring
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
			where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
			where = where + ')'

			dbcur.execute('SELECT  start, end, description,uuid,repeat,repeatvalue,frequency,until,byday FROM events  '+where + '  AND description<>"DELETED" ORDER by start')       
			events = dbcur.fetchall()
			if len(events)!=0:
			  text = text + "\n\n<b>Tomorrow "+self.view_datetime.strftime('%x')+"</b>"
			for event in events:
			  repeat = event[4]
			  repeatvalue = int(event[5])
			  frequency = event[6]
			  byday = event[8]
			  until = datetime.datetime.strptime(event[7],'%Y-%m-%d %H:%M')
			  start_datetime = datetime.datetime.strptime(event[0],'%Y-%m-%d %H:%M')
			  end_datetime = datetime.datetime.strptime(event[1],'%Y-%m-%d %H:%M')
			  if not repeat:
			    text = text + '\n'+ start_datetime.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			  else:
			    if frequency=="Day(s)":
			      diff = datetime.timedelta(days=repeatvalue)
			      d = start_datetime
			      while (d.date() <= until.date()) and (d.date() <= self.view_datetime.date()):
			        if (d.date() == self.view_datetime.date()) and (self.view_datetime.weekday() in googleToDays(byday)):
			  			  text = text +'\n'+ d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = d+diff
			    elif frequency=="Week(s)":
			      diff = datetime.timedelta(days=repeatvalue*7)
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
			          text = text +'\n'+ d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = d+diff
			    elif frequency=="Month(s)":
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
			          text = text + '\n'+d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = addMonth(d,repeatvalue) 
			    elif frequency=="Year(s)":
			      d = start_datetime
			      while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
			        if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%W")==self.view_datetime.strftime("%W"))) and (self.view_datetime.weekday() in googleToDays(byday)):
			          text = text + '\n'+d.strftime(WEEK_VIEW_FORMAT)+':'+event[2]
			        d = addMonth(d,repeatvalue*12) 

			db.close()
		except StandardError,e:
			print e
			text = 'Error while connecting to db : %s' % e
		return text

def hd_plugin_get_objects():
	plugin = IPPlugin()
	return [plugin]

if __name__ == "__main__":
  print IPPlugin().get_text()