// -*- c++ -*-
#ifndef _HILDONMM_HELPER_H
#define _HILDONMM_HELPER_H

/* $Id: helper.h,v 1.1 2003/11/03 09:27:31 murrayc Exp $ */

/* Copyright 2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/rc.h>

namespace Hildon
{

namespace Helper
{

/* TODO: Use a SignalProxy: */
/**  This function assigns a defined logical font to the @a widget and all its child widgets.
 * It also connects to the "style_set" signal which will retrieve & assign the new font 
 * for the given logical name each time the theme is changed.
 * The returned signal id can be used to disconnect the signal. 
 * When calling multiple times the previous signal (obtained by calling this function) is disconnected 
 * automatically and should not be used. 
 *
 * @param widget A Gtk::Widget to assign this logical font for.
 * @param logicalfontname A string with the logical font name to assign to the widget.
 * @result the signal id that is triggered every time theme is changed. 0 if font set failed.
 */
gulong set_logical_font(Gtk::Widget& widget,  const Glib::ustring& logicalfontname);

/* TODO: Use a SignalProxy: */
/** This function assigns a defined logical color to the @a widget and all it's child widgets.
 * It also connects to the "style_set" signal which will retrieve & assign the new color 
 * for the given logical name each time the theme is changed.
 * The returned signal id can be used to disconnect the signal.
 * When calling multiple times the previous signal (obtained by calling this function) is disconnected 
 * automatically and should not be used. 
 * 
 * Example : If the style you want to modify is bg[NORMAL] then set rcflags to GTK_RC_BG and state to GTK_STATE_NORMAL.
 * 
 * @param widget A Gtk::Widget to assign this logical font for.
 * @param rcflags : Flags enumeration defining whether to assign to FG, BG, TEXT or BASE style.
 * @param state Indicates to which state to assign the logical color
 * @param logicalcolorname A string with the logical font name to assign to the widget.
 * @result The signal id that is triggered every time theme is changed. 0 if color set failed.
 */
gulong set_logical_color(Gtk::Widget& widget, Gtk::RcFlags rcflags, Gtk::StateType state,  const Glib::ustring& logicalcolorname);

/** Checks if the given button event is a finger event.
 * @param event A @gtkeventbutton to check
 * @result true if the event is a finger event.
 */
bool event_button_is_finger(GdkEventButton* event);

/** This function assigns an insensitive message to a @a widget. When the @a widget is 
 * in an insensitive state and the user activates it, the @a message will be displayed
 * using a standard Hildon::Banner. 
 *
 * @param widget A Gtk::Widget to assign a banner to.
 * @param message A message to display to the user.
 */
void set_insensitive_message(Gtk::Widget& widget, const Glib::ustring& message);

/** This function enables a thumb scrollbar on a given scrolled window. It'll convert the
 * existing normal scrollbar into a larger, finger-usable scrollbar that works without a stylus. 
 * As fingerable list rows are fairly high, consider using the whole available vertical space 
 * of your application for the content in order to have as many rows as possible 
 * visible on the screen at once. 
 *
 * Finger-Sized scrollbar should always be used together with finger-sized content.
 *
 * @param win: A Gtk::ScrolledWindow to use as target.
 * @param thumb true to enable the thumb scrollbar, false to disable.
 */
void set_thumb_scrollbar  (Gtk::ScrolledWindow& win, bool thumb = true);

} // namespace Helper

} // namespace Hildon



#endif /* _HILDONMM_HELPER_H */

