// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_VOLUMEBAR_H
#define _HILDONMM_VOLUMEBAR_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* volumebar.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/adjustment.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonVolumebar HildonVolumebar;
typedef struct _HildonVolumebarClass HildonVolumebarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Volumebar_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Volumebar is a base class for widgets that display a volume bar that
 * allows increasing or decreasing volume within a predefined range, and muting
 * the volume when users click the mute icon.
 *
 * @ingroup HildonWidgets
 */

class Volumebar : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Volumebar CppObjectType;
  typedef Volumebar_Class CppClassType;
  typedef HildonVolumebar BaseObjectType;
  typedef HildonVolumebarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Volumebar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Volumebar_Class;
  static CppClassType volumebar_class_;

  // noncopyable
  Volumebar(const Volumebar&);
  Volumebar& operator=(const Volumebar&);

protected:
  explicit Volumebar(const Glib::ConstructParams& construct_params);
  explicit Volumebar(HildonVolumebar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonVolumebar*       gobj()       { return reinterpret_cast<HildonVolumebar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonVolumebar* gobj() const { return reinterpret_cast<HildonVolumebar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_mute_toggled();
  virtual void on_level_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Volumebar();

  
  /** Sets new volume level for this Hildon::Volumebar.
   * @param level New level.
   */
  void set_level(double level);
  
  /** Gets the volume level of this Hildon::Volumebar.
   * @return Volume level or -1 on error.
   */
  double get_level() const;
  
  /** Sets mute status for this Hildon::Volumebar.
   * @param mute Mute ON/OFF.
   */
  void set_mute(bool mute = true);
  
  /** Gets mute status of this Hildon::Volumebar (ON/OFF).
   * @return Mute status as <tt>bool</tt> value.
   */
  bool get_mute() const;

  
  /** Gets the GtkAdjustment used in volume bar. This can be handy
   * to pass to hildon_appview_set_connected_adjustment which
   * will allow changing the volume with 'increase' / 'decrease'
   * hardware buttons.
   * @return A Gtk::Adjustment used by volume bar.
   */
  Gtk::Adjustment* get_adjustment();
  
  /** Gets the GtkAdjustment used in volume bar. This can be handy
   * to pass to hildon_appview_set_connected_adjustment which
   * will allow changing the volume with 'increase' / 'decrease'
   * hardware buttons.
   * @return A Gtk::Adjustment used by volume bar.
   */
  const Gtk::Adjustment* get_adjustment() const;

  //TODO: When the first argument type has been corrected.
  //See https://bugs.maemo.org/show_bug.cgi?id=1848 :
  
  /** Used to asign an insensitive message to the slider of the given volumebar.
   * It simply calls hildon_helper_set_insensitive_message on the slider/range of 
   * the volumebar.
   * @param message A message to display to the user.
   */
  void set_range_insensitive_message(const Glib::ustring& message);
  

   /**
   * @par Prototype:
   * <tt>void %mute_toggled()</tt>
   */

  Glib::SignalProxy0< void > signal_mute_toggled();

  
   /**
   * @par Prototype:
   * <tt>void %level_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_level_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can accept the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can accept the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mute button is visible. Default value: TRUE.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_mute() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mute button is visible. Default value: TRUE.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_mute() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current volume level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_level() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current volume level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_level() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether volume is muted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_mute() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether volume is muted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_mute() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Volumebar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Volumebar* wrap(HildonVolumebar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_VOLUMEBAR_H */

