// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_NUMBER_EDITOR_H
#define _HILDONMM_NUMBER_EDITOR_H


#include <glibmm.h>

/* $Id: number-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* number-editor.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonNumberEditor HildonNumberEditor;
typedef struct _HildonNumberEditorClass HildonNumberEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class NumberEditor_Class; } // namespace Hildon
namespace Hildon
{

//Wrap this by hand, because the C enum doesn't have a prefix.
//Keep the sequence the same as the C enum.
//_WRAP_ENUM(NumberEditorErrorType, HildonNumberEditorErrorType)
//TODO: Provide a patch to fix this.

//TODO: Check that this is up to date:
enum NumberEditorErrorType
{
  ERROR_MAXIMUM_VALUE_EXCEED,
  ERROR_MINIMUM_VALUE_EXCEED,
  ERROR_ERRONEOUS_VALUE
};

/** Hildon::NumberEditor is used to enter a number from a specific range. 
 * There are two buttons to scroll the value in number field. 
 * Manual input is also possible.
 *
 * @ingroup HildonWidgets
 */

class NumberEditor : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef NumberEditor CppObjectType;
  typedef NumberEditor_Class CppClassType;
  typedef HildonNumberEditor BaseObjectType;
  typedef HildonNumberEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~NumberEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class NumberEditor_Class;
  static CppClassType numbereditor_class_;

  // noncopyable
  NumberEditor(const NumberEditor&);
  NumberEditor& operator=(const NumberEditor&);

protected:
  explicit NumberEditor(const Glib::ConstructParams& construct_params);
  explicit NumberEditor(HildonNumberEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonNumberEditor*       gobj()       { return reinterpret_cast<HildonNumberEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonNumberEditor* gobj() const { return reinterpret_cast<HildonNumberEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_range_error(NumberEditorErrorType type);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  explicit NumberEditor(int min, int max);

  
  /** Sets accepted number range for editor
   * @param min Minimum accepted value.
   * @param max Maximum accepted value.
   */
  void set_range(int min, int max);

  
  /** 
   * @return Current NumberEditor value.
   */
  int get_value() const;
  
  /** Sets numeric value for number editor
   * @param value Numeric value for number editor.
   */
  void set_value(int value);

  //Ideally this would be wrapped as an exception, but that's too difficult.
  
   /**
   * @par Prototype:
   * <tt>bool %range_error(NumberEditorErrorType type)</tt>
   */

  Glib::SignalProxy1< bool,NumberEditorErrorType > signal_range_error();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current value of number editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_value() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The current value of number editor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_value() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::NumberEditor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::NumberEditor* wrap(HildonNumberEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_NUMBER_EDITOR_H */

