// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_NOTE_H
#define _HILDONMM_NOTE_H


#include <glibmm.h>

/* $Id: note.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* note.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/progressbar.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonNote HildonNote;
typedef struct _HildonNoteClass HildonNoteClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Note_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum NoteType
{
  NOTE_TYPE_CONFIRMATION,
  NOTE_TYPE_CONFIRMATION_BUTTON,
  NOTE_TYPE_INFORMATION,
  NOTE_TYPE_INFORMATION_THEME,
  NOTE_TYPE_PROGRESSBAR
};


/** Notes are used to for confirmation (OK/Cancel/etc.) from the user.
 * A simple note contains information text and an OK button to be
 * clicked. Additional features such as progress bars or animation can
 * also be included.
 *
 * @ingroup HildonDialogs
 */

class Note : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Note CppObjectType;
  typedef Note_Class CppClassType;
  typedef HildonNote BaseObjectType;
  typedef HildonNoteClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Note();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Note_Class;
  static CppClassType note_class_;

  // noncopyable
  Note(const Note&);
  Note& operator=(const Note&);

protected:
  explicit Note(const Glib::ConstructParams& construct_params);
  explicit Note(HildonNote* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonNote*       gobj()       { return reinterpret_cast<HildonNote*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonNote* gobj() const { return reinterpret_cast<HildonNote*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  Note();

  explicit Note(Gtk::Window& parent, const Glib::ustring& description);

  explicit Note(Gtk::Window& parent, const Glib::ustring& description, const Glib::ustring& icon_name);
  explicit Note(const Glib::ustring& description, const Gtk::StockID& stock_id = Gtk::StockID());

  Note(NoteType note_type, Gtk::Window& parent, const Glib::ustring& description = Glib::ustring(), const Gtk::StockID& stock_id = Gtk::StockID());
  explicit Note(NoteType note_type, const Glib::ustring& description = Glib::ustring(), const Gtk::StockID& stock_id = Gtk::StockID());

  //Creates a "cancel" dialog:

  Note(const Glib::ustring& description, const Gtk::StockID& stock_id, const Gtk::ProgressBar& progress_bar);
  

  /** Sets the button text to be used by the hildon_note widget.
   * @param text Sets the button text and if there is two buttons in dialog, 
   * the button texts will be &lt;text&gt;, "Cancel".
   */
  void set_button_text(const Glib::ustring& text);

  
  /** Sets the button texts to be used by this hildon_note widget.
   * @param text_ok The new text of the default OK button.
   * @param text_cancel The new text of the default cancel button.
   */
  void set_button_text(const Glib::ustring& textOk, const Glib::ustring& textCancel);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<NoteType> property_note_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<NoteType> property_note_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the icon that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_icon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the icon that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_icon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The stock name of the icon that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::StockID> property_stock_icon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The stock name of the icon that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::StockID> property_stock_icon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The progressbar that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::ProgressBar*> property_progressbar() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The progressbar that appears in the note dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::ProgressBar*> property_progressbar() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Note
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Note* wrap(HildonNote* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_NOTE_H */

