// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_WEEKDAY_PICKER_H
#define _HILDONMM_WEEKDAY_PICKER_H


#include <glibmm.h>

/* $Id: weekday-picker.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* weekday-picker.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonWeekdayPicker HildonWeekdayPicker;
typedef struct _HildonWeekdayPickerClass HildonWeekdayPickerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class WeekdayPicker_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::WeekdayPicker supports non-mutually exclusive selection of days of 
 * the week. Selected days of the week are shown with a pushed-in effect.
 * 
 * This dialog is used where users are required to pick days on which 
 * a certain event should take place, for example, on which days a Calendar event 
 * should be repeated. It is used in the Maemo Calendar in the Repeat dialog, in Maemo Tasks 
 * in the Repeat dialog and in the Email application's set-up wizard.
 *
 * @ingroup HildonDialogs
 */

class WeekdayPicker : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef WeekdayPicker CppObjectType;
  typedef WeekdayPicker_Class CppClassType;
  typedef HildonWeekdayPicker BaseObjectType;
  typedef HildonWeekdayPickerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~WeekdayPicker();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class WeekdayPicker_Class;
  static CppClassType weekdaypicker_class_;

  // noncopyable
  WeekdayPicker(const WeekdayPicker&);
  WeekdayPicker& operator=(const WeekdayPicker&);

protected:
  explicit WeekdayPicker(const Glib::ConstructParams& construct_params);
  explicit WeekdayPicker(HildonWeekdayPicker* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonWeekdayPicker*       gobj()       { return reinterpret_cast<HildonWeekdayPicker*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonWeekdayPicker* gobj() const { return reinterpret_cast<HildonWeekdayPicker*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  WeekdayPicker();

  
  /** Sets specified weekday active.
   * @param day Day to be set active.
   */
  void set_day(Glib::Date::Weekday day);
  
  /** Unselect specified weekday.
   * @param day Day to be set inactive.
   */
  void unset_day(Glib::Date::Weekday day);
  
  /** Toggles current status of the specified weekday.
   * @param day Day to be toggled.
   */
  void toggle_day(Glib::Date::Weekday day);
  
  /** Sets all weekdays active.
   */
  void set_all();
  
  /** Sets all weekdays inactive.
   */
  void unset_all();

  //We change the name of this function for C++, because isset_day() is such a bad name:
  
  /** Checks if the specified weekday is set active.
   * @param day Day to be checked.
   * @return <tt>true</tt> if the day is set, <tt>false</tt> if the day is not set.
   */
  bool get_day_is_set(Glib::Date::Weekday day) const;


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::WeekdayPicker
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::WeekdayPicker* wrap(HildonWeekdayPicker* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_WEEKDAY_PICKER_H */

