// -*- c++ -*-
/* $Id: helper.cc,v 1.1 2003/11/03 09:27:31 murrayc Exp $ */

/* Copyright 2007 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <hildonmm/helper.h>
#include <hildon/hildon-helper.h>

namespace Hildon
{

namespace Helper
{

gulong set_logical_font(Gtk::Widget& widget, const Glib::ustring& logicalfontname)
{
  return hildon_helper_set_logical_font(widget.gobj(), logicalfontname.c_str());
}

gulong set_logical_color(Gtk::Widget& widget, Gtk::RcFlags rcflags, Gtk::StateType state,  const Glib::ustring& logicalcolorname)
{
  return hildon_helper_set_logical_color(widget.gobj(), (GtkRcFlags)rcflags, (GtkStateType)state,  logicalcolorname.c_str());
}

bool event_button_is_finger(GdkEventButton* event)
{
  return hildon_helper_event_button_is_finger(event);
}

void set_insensitive_message(Gtk::Widget& widget, const Glib::ustring& message)
{
  hildon_helper_set_insensitive_message(widget.gobj(), message.c_str());
}

void set_thumb_scrollbar(Gtk::ScrolledWindow& win, bool thumb)
{
  hildon_helper_set_thumb_scrollbar(win.gobj(), thumb);
}


} // namespace Helper

} // namespace Hildon

