// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_WINDOW_H
#define _HILDONMM_WINDOW_H


#include <glibmm.h>

/* $Id: window.hg,v 1.10 2006/22/9 10:52:44 murrayc Exp $ */

/* window.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/window.h>
#include <gtkmm/menu.h>
#include <gtkmm/toolbar.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonWindow HildonWindow;
typedef struct _HildonWindowClass HildonWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Window_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Window represents a top-level window of an application running in the Hildon framework. 
 * It provides facilities to manage window menus and toolbars. 
 * 
 * Each Hildon::Window can have its own menu and toolbars. The application can also have a common 
 * menu and toolbar, which are shared among all application windows. 
 * For more information, see Hildon::Program.
 * 
 * The following methods are particularly important:
 * - set_menu() sets a menu for the Hildon::Window.
 * - add_toolbar() adds a toolbar for the Hildon::Window.
 */

class Window : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef HildonWindow BaseObjectType;
  typedef HildonWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(HildonWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonWindow*       gobj()       { return reinterpret_cast<HildonWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonWindow* gobj() const { return reinterpret_cast<HildonWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  Window();
		
  
  /** Adds the @a child  to the HildonWindow and creates a scrollbar
   * to it. Similar as adding first a @a GtkScrolledWindow  and then the
   *  @a child  to it.
   * @param child A @a GtkWidget .
   */
  void add_with_scrollbar(Gtk::Widget& child);
		
  
  /** Gets the Gt::Menu assigned to the Hildon::Appview.
   * @return The Gtk::Menu assigned to this application view.
   */
  Gtk::Menu* get_menu();
  
  /** Gets the Gt::Menu assigned to the Hildon::Appview.
   * @return The Gtk::Menu assigned to this application view.
   */
  const Gtk::Menu* get_menu() const;
  
  /** Sets the menu to be used for this window. This menu overrides
   * a program-wide menu that may have been set with
   * hildon_program_set_common_menu.
   * @param menu The Gtk::Menu to be used for this Hildon::Window.
   */
  void set_menu(Gtk::Menu& menu);
		
  
  /** Adds a toolbar to the window.
   * @param toolbar A Gtk::Toolbar to add to the HildonWindow.
   */
  void add_toolbar(Gtk::Toolbar& toolbar);
  
  /** Removes a toolbar from the window.
   * @param toolbar A Gtk::Toolbar to remove from the HildonWindow.
   */
  void remove_toolbar(Gtk::Toolbar& toolbar);
		
  
  /** 
   * @return Whether or not the Hildon::Window is currenltly activated
   * by the window manager.
   */
  bool get_is_topmost() const;
		
  // These are from the hildon-window-private.h header, so we can assume that they are not public API.
  
  
  //We don't wrap this because it is documented as "opera hack", so it is unlikely to be useful:
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the window is currently activated by the window manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_topmost() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Window
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Window* wrap(HildonWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_WINDOW_H */

