// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_SORT_DIALOG_H
#define _HILDONMM_SORT_DIALOG_H


#include <glibmm.h>

/* $Id: set-password-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* sort-dialog.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonSortDialog HildonSortDialog;
typedef struct _HildonSortDialogClass HildonSortDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class SortDialog_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::SortDialog is used to define an order (ascending/descending)
 * and a field by which items are sorted in a list. The combo boxes
 * display the current value when the dialog is opened.
 *
 * @ingroup HildonDialogs
 */

class SortDialog : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SortDialog CppObjectType;
  typedef SortDialog_Class CppClassType;
  typedef HildonSortDialog BaseObjectType;
  typedef HildonSortDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SortDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SortDialog_Class;
  static CppClassType sortdialog_class_;

  // noncopyable
  SortDialog(const SortDialog&);
  SortDialog& operator=(const SortDialog&);

protected:
  explicit SortDialog(const Glib::ConstructParams& construct_params);
  explicit SortDialog(HildonSortDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonSortDialog*       gobj()       { return reinterpret_cast<HildonSortDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonSortDialog* gobj() const { return reinterpret_cast<HildonSortDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  SortDialog();

  
  /** Gets index to currently active sort key.
   * @return An integer which is the index value of the "Sort by" 
   * field.
   */
  int get_sort_key() const;
  
  /** Gets current sorting order from "Sort order" field.
   * @return Current sorting order as Gtk::SortType.
   */
  Gtk::SortType get_sort_order() const;
  
  /** Sets the index value of the Hildon::SortDialog widget.
   * @param key Combo box's index value.
   */
  void set_sort_key(int key);
  
  /** Sets the index value of the Hildon::SortDialog widget.
   * @param order Combo box's index value.
   */
  void set_sort_order(Gtk::SortType order);
  
  /** Adds a new sort key and returns the respective index in
   * sort key combobox.
   * @param sort_key Combo box's index value.
   * @return An integer which is the index of the added combo box's
   * item.
   */
  int add_sort_key(const Glib::ustring& sort_key);
  
  int add_sort_key_reversed(const Glib::ustring& sort_key);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently active sort key.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_sort_key() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently active sort key.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_sort_key() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current sorting order.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::SortType> property_sort_order() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The current sorting order.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::SortType> property_sort_order() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::SortDialog
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::SortDialog* wrap(HildonSortDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_SORT_DIALOG_H */

