// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_CONTROLBAR_H
#define _HILDONMM_CONTROLBAR_H


#include <glibmm.h>

/* $Id: add-home-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* control-bar.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/scale.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonControlbar HildonControlbar;
typedef struct _HildonControlbarClass HildonControlbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Controlbar_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Controlbar is widget that allows increasing or decreasing
 * a value within a pre-defined range.
 * It is a horizontally positioned range widget that is
 * visually divided into blocks and supports setting a minimum and
 * maximum value for the range.
 *
 * @ingroup HildonWidgets
 */

class Controlbar : public Gtk::Scale
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Controlbar CppObjectType;
  typedef Controlbar_Class CppClassType;
  typedef HildonControlbar BaseObjectType;
  typedef HildonControlbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Controlbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Controlbar_Class;
  static CppClassType controlbar_class_;

  // noncopyable
  Controlbar(const Controlbar&);
  Controlbar& operator=(const Controlbar&);

protected:
  explicit Controlbar(const Glib::ConstructParams& construct_params);
  explicit Controlbar(HildonControlbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonControlbar*       gobj()       { return reinterpret_cast<HildonControlbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonControlbar* gobj() const { return reinterpret_cast<HildonControlbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_end_reached(bool end);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Controlbar();
  

  /** Change the current value of the control bar to the specified value.
   * @param value Value in range of &gt;= 0 && &lt; G_MAX_INT.
   */
  void set_value(int value);
  
  /** 
   * @return Current value as <tt>int</tt>.
   */
  int get_value() const;
  
  /** 
   * @return Maximum value of control bar.
   */
  int get_max() const;
  
  /** 
   * @return Minimum value of controlbar.
   */
  int get_min() const;
  
  /** Set the control bar's maximum to the given value.
   * 
   * If the new maximum is smaller than current value, the value will be
   * adjusted so that it equals the new maximum.
   * @param max Maximum value to set. The value needs to be greater than 0.
   */
  void set_max(int max);
  
  /** Set the control bar's minimum to the given value.
   * 
   * If the new minimum is smaller than current value, the value will be
   * adjusted so that it equals the new minimum.
   * @param min Minimum value to set. The value needs to be greater than or
   * equal to 0.
   */
  void set_min(int min);
  
  /** Set the controlbars range to the given value
   * 
   * If the new maximum is smaller than current value, the value will be
   * adjusted so that it equals the new maximum.
   * 
   * If the new minimum is smaller than current value, the value will be
   * adjusted so that it equals the new minimum.
   * @param max Maximum value to set. The value needs to be greater than 0.
   * @param min Minimum value to set. The value needs to be greater than or
   * equal to 0.
   */
  void set_range(int min, int max);

  
   /**
   * @par Prototype:
   * <tt>void %end_reached(bool end)</tt>
   */

  Glib::SignalProxy1< void,bool > signal_end_reached();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Smallest possible value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_min() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Smallest possible value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_min() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Greatest possible value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Greatest possible value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_value() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_value() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Controlbar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Controlbar* wrap(HildonControlbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_CONTROLBAR_H */

