/*
 * GStreamer
 * Copyright 2007 Danilo Freire <danilo@embedded.ufcg.edu.br>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_RADIO_BIN_H__
#define __GST_RADIO_BIN_H__

#include <gst/gst.h>
#include <gst/interfaces/tuner.h>
#include <linux/videodev.h>

G_BEGIN_DECLS

#define GST_TYPE_RADIOBIN \
  (gst_radiobin_get_type())
#define GST_RADIOBIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_RADIOBIN,GstRadioBin))
#define GST_RADIOBIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_RADIOBIN,GstRadioBinClass))
#define GST_IS_RADIOBIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_RADIOBIN))
#define GST_IS_RADIOBIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_RADIOBIN))

typedef struct _GstRadioBin      GstRadioBin;
typedef struct _GstRadioBinClass GstRadioBinClass;


struct _GstRadioBin
{
  GstElement element;

  gint active_input;
  GList *channels;

  /* V4l2 structures */
  struct v4l2_capability vc;
  struct v4l2_tuner vt;
  struct v4l2_control vctrl;
  struct v4l2_frequency vf;

  char *radio_dev;
  char *mixer_dev;

  gint radio_fd;
  gint mixer_fd;

  guint freq;
  guint  vol;

  gboolean silent;
};

struct _GstRadioBinClass
{
  GstElementClass parent_class;
};

GType gst_radiobin_get_type (void);

G_END_DECLS

#endif /* __GST_RADIO_BIN_H__ */
