/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "main_window.h"
#include "save_game.h"
#include "sudoku_worksheet.h"

extern GtkWidget *nums[10];
extern struct sudoku_worksheet *ws;
extern GtkWidget *save_dlg;
extern GtkWidget *guess_toggle;

gboolean
button_press (GtkWidget *widget,
              GdkEventButton *event,
              gpointer d)
{
	guint cell_num, x, y ; 
	struct sudoku_big_square *bs = (struct sudoku_big_square *)d;
	
	x = event->x;
	y = event->y;
	
	cell_num = cell_number_from_event(x,y, bs);
	
	/* I'm not guessing */
	if(!gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(guess_toggle)))
	{
		cell_pressed(cell_num);	
	}else{
		/* I'm guessing */
		gint  sel_num = get_selected_num();
		sudoku_worksheet_add_guess(ws, cell_num, sel_num);
	}
	draw_big_square(bs);

	return(FALSE);
	
}

gint
draw_expose_event (GtkWidget *widget,
                   GdkEventExpose *event,
                   gpointer user_data)
{
	struct sudoku_big_square *bs = (struct sudoku_big_square *)user_data;
	draw_big_square(bs);
	return 0;
}



/** True if number is in row */
gboolean check_row(gint cell, gint number)
{
	gint i;
	gint num;
	
	for(i = GET_ROW(cell)*9 ; i< GET_ROW(cell)*9+9 ; i++)
	{
		gint row_num;
		
		num = ws->s_cells[i]->cell;
		
		if(num){
			row_num = num;
		
			if(row_num == number){

				return TRUE;	
			}
			
		}
	}
	

	return FALSE;
	
}


gint cell_value(gint i)
{
	gint num ;
	num = ws->s_cells[i]->cell;
		
	if(num){
		return((num));
	}else{
		return -1;
	}
}

/** True if number is in column */
gboolean 
check_column(gint cell, gint number)
{
	gint i=0,j;
	gint num;
	
		
	j = GET_COL(cell);
	while( i < 9 ){
		gint col_num;
		
		i++;
		
		num = ws->s_cells[j]->cell;
		
		if(num){
			col_num = num;
		
			if(col_num == number){
				
				return TRUE;	
			}
			
		}
		j+=9;
	}
	

	return FALSE;
}


gboolean 
check_square(gint cell, gint number)
{
	gint row = GET_ROW(cell);
	gint col = GET_COL(cell);
	gint y_s = row/3;
	gint x_s = col/3;
	gint i,j, square_num;
	gint num;
		
	for(i=y_s*3 ; i< y_s*3+3 ; i++){
		for(j=x_s*3 ; j < x_s*3+3 ; j++){
			num = ws->s_cells[i*9+j]->cell;
			if(num){
				square_num = num;
		
				if(square_num == number){
					return TRUE;	
				}
			
			}	
		}
	}
		
	return FALSE;
	
}

gboolean
select_num (GtkWidget *toggle, gpointer user_data)
{
	int i;

	if(!gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(toggle))){
		return TRUE;
	}
	
	for(i = 0 ; i<=9 ; i++){
		if(nums[i] != toggle){
			gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(nums[i]),FALSE);
		}
	} 
	return TRUE;
}


gboolean
del_guess_square(gint cell, gint number)
{
	gint row = GET_ROW(cell);
	gint col = GET_COL(cell);
	gint y_s = row/3;
	gint x_s = col/3;
	gint i,j;
	gboolean del_flag = FALSE;	
	
	for(i=y_s*3 ; i< y_s*3+3 ; i++){
		for(j=x_s*3 ; j < x_s*3+3 ; j++){
			if(sudoku_worksheet_is_in_guess(ws,i*9+j, number)){
				del_flag |= sudoku_worksheet_del_guess(ws,i*9+j,number);	
			}	
		}
	}
	return del_flag;
}

gboolean
del_guess_row(gint cell, gint number)
{
	gint i;
	gboolean del_flag = FALSE;
	for(i = GET_ROW(cell)*9 ; i< GET_ROW(cell)*9+9 ; i++)
	{
		if(sudoku_worksheet_is_in_guess(ws,i, number)){
				del_flag |= sudoku_worksheet_del_guess(ws,i,number);	
		}	
	}
	return del_flag;
}

gboolean
del_guess_column(gint cell, gint number)
{
	gint i=0,j;
	gboolean del_flag=FALSE;
	j = GET_COL(cell);
	while( i < 9 ){
		i++;
				
		if(sudoku_worksheet_is_in_guess(ws,j, number)){
			del_flag |= sudoku_worksheet_del_guess(ws,j,number);
		}	
		j+=9;
	}
	return del_flag;
}


gboolean 
on_close (GtkWidget *widget, GdkEvent  *event,
	   gpointer   user_data)
{
	if(!decide_on_changes(ws)){
		return TRUE;
	}else{
		gtk_main_quit();
		return TRUE;
	}
}


