/*
 * This file is part of eostimesync
 *
 * Author:  Marcell Lengyel <marcell@maemo.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef EOSTIMESYNC_PLUGIN_H
#define EOSTIMESYNC_PLUGIN_H

#include <glib-object.h>
#include <libhildondesktop/hildon-desktop-home-item.h>

G_BEGIN_DECLS

#define PIXMAP_PATH      "/usr/share/pixmaps/eostimesync"
#ifdef __i386__
#define NTP_COMMAND      "/usr/sbin/ntpdate %s 2>&1"
#define S10SH_COMMAND    "/usr/bin/s10sh -T 2>&1"
#define USB_MODE_PATH    "~/mode"
#define USB_HOST_COMMAND "/usr/local/bin/usb_host_mode.sh 2>&1"
#define USB_OTG_COMMAND  "/usr/local/bin/usb_otg_mode.sh 2>&1"
#else
#define NTP_COMMAND      "sudo /usr/sbin/ntpdate %s 2>&1"
#define RETUTIME_COMMAND "sudo /mnt/initfs/usr/bin/retutime --rtc-from-system 2>&1"
#define S10SH_COMMAND    "sudo /usr/bin/s10sh -t 2>&1"
#define USB_MODE_PATH    "/sys/devices/platform/musb_hdrc/mode"
#define USB_HOST_COMMAND "sudo /usr/local/bin/usb_host_mode.sh 2>&1"
#define USB_OTG_COMMAND  "sudo /usr/local/bin/usb_otg_mode.sh 2>&1"
#endif

static const int USB_MODE_OTG  = 0;
static const int USB_MODE_HOST = 1;

typedef struct _EosTimeSyncPlugin EosTimeSyncPlugin;
typedef struct _EosTimeSyncPluginClass EosTimeSyncPluginClass;
typedef struct _EosTimeSyncPluginPrivate EosTimeSyncPluginPrivate;

#define EOS_TIME_SYNC_TYPE_PLUGIN            (eos_time_sync_plugin_get_type ())
#define EOSTIMESYNC_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), EOS_TIME_SYNC_TYPE_PLUGIN, EosTimeSyncPlugin))
#define EOSTIMESYNC_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  EOS_TIME_SYNC_TYPE_PLUGIN, EosTimeSyncPluginClass))
#define EOS_TIME_SYNC_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EOS_TIME_SYNC_TYPE_PLUGIN))
#define EOS_TIME_SYNC_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  EOS_TIME_SYNC_TYPE_PLUGIN))
#define EOSTIMESYNC_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  EOS_TIME_SYNC_TYPE_PLUGIN, EosTimeSyncPluginClass))

struct _EosTimeSyncPlugin 
{
  HildonDesktopHomeItem item;

  EosTimeSyncPluginPrivate *priv;
};

struct _EosTimeSyncPluginClass 
{
  HildonDesktopHomeItemClass parent_class;
};

GType  eos_time_sync_plugin_get_type  (void);

G_END_DECLS

#endif
