/*
  EightyOne - A simple Sudoku solving game
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "GenerateDialog.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/OS/Theme.h>

#include <Lum/ButtonRow.h>
#include <Lum/Combo.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>

GenerateDialog::GenerateDialog(size_t points)
 : commitAction(new Lum::Model::Action()),
   points(new Lum::Model::String(Lum::Base::NumberToWString(points))),
   success(false)
{
  commitAction->Disable();

  Observe(GetClosedAction());

  Observe(commitAction);
  Observe(this->points);
}

Lum::Object* GenerateDialog::GetContent()
{
  Lum::TextEditCombo         *combo;
  Lum::Label                 *label;
  Lum::Model::StringTableRef pointsModel;

  label=Lum::Label::Create(true,false);

  pointsModel=new Lum::Model::StringTable();
  pointsModel->Append(L"2500");
  pointsModel->Append(L"4000");
  pointsModel->Append(L"8000");
  pointsModel->Append(L"15000");
  pointsModel->Append(L"25000");

  combo=new Lum::TextEditCombo();
  combo->SetFlex(true,false);
  combo->SetModel(points);
  combo->SetTableModel(pointsModel);
  combo->GetString()->SetAlignment(Lum::String::right);
  label->AddLabel(_(L"POINTS_MIN",L"Min. Points:"),combo);

  return label;
}

void GenerateDialog::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  actions.push_back(Lum::Dlg::ActionInfo(Lum::Dlg::ActionInfo::typeCommit,
                                         _(L"GENERATE",L"_Generate"),
                                         Lum::OS::display->GetTheme()->GetStockImage(Lum::OS::Theme::imagePositive),
                                         commitAction,
                                         true));

  CreateActionInfosCancel(actions,GetClosedAction());
}

void GenerateDialog::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==commitAction && commitAction->IsFinished()) {
    success=true;
    Exit();
  }
  else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }
  else if (model==points) {
    size_t tmp;

    if (Lum::Base::WStringToNumber(points->Get(),tmp) && tmp>0) {
      commitAction->Enable();
    }
    else {
      commitAction->Disable();
    }
  }

  Dialog::Resync(model,msg);
}

bool GenerateDialog::GetSuccess() const
{
  return success;
}

size_t GenerateDialog::GetPoints() const
{
  size_t tmp=0;

  if ((!Lum::Base::WStringToNumber(points->Get(),tmp) && tmp>0)) {
    assert(false);
  }

  return tmp;
}

bool ShowGenerateDialog(Lum::Dialog* parent, size_t& points)
{
  GenerateDialog *dialog;
  bool            success;

  dialog=new GenerateDialog(points);
  dialog->SetParent(parent);

  if (dialog->Open()) {
    dialog->EventLoop();
    dialog->Close();
  }

  success=dialog->GetSuccess();
  if (success) {
    points=dialog->GetPoints();
  }

  delete dialog;

  return success;
}

