/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <stdlib.h>
#include <locale.h>
#include <errno.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <glib/gthread.h>
#include <glib/gstdio.h>
#include <libosso.h>
#include "ui.h"
#include "coverfinder.h"

static CFApp *app_init ()
{
	CFApp *app;
	CFConfig *config;
	const gchar *cache_home;

	app = g_new (CFApp, 1);
	config = g_new (CFConfig, 1);

	cache_home = g_get_user_cache_dir ();
	config->cache_dir = g_build_filename (cache_home, "coverfinder", NULL);
	if (!g_file_test (config->cache_dir, G_FILE_TEST_IS_DIR)) {
		if (g_mkdir_with_parents (config->cache_dir, S_IRWXU) == -1) {
			g_fprintf (stderr, "Can't create cache directory: %s.\n", g_strerror (errno));
			exit (EXIT_FAILURE);
		}
	}

	app->config = config;
	return app;
}

static gint
dbus_cb_default(const gchar *interface, const gchar *method,
        GArray *arguments, gpointer data, osso_rpc_t *retval)
{

    retval->type = DBUS_TYPE_INVALID;

    return OSSO_OK;
}

static osso_context_t *_osso = NULL;
//static DBusConnection *system_dbus;
//void dbus_connection_setup_with_g_main (DBusConnection *connection, GMainContext *context);
//static GMainLoop *main_loop;

int main (int argc, char **argv)
{
	CFApp *app;

	setlocale (LC_ALL, "");
	g_thread_init (NULL);
        /* Initialize _osso. */
        _osso = osso_initialize("org.mookooh.coverfinder", "0.1.1", TRUE, NULL);
        if(!_osso)
        {
            g_printerr("osso_initialize failed.\n");
            return 1;
        }
        g_type_init();
        //main_loop = g_main_loop_new(NULL, FALSE);
        //system_dbus = dbus_bus_get(DBUS_BUS_SYSTEM, NULL);
        //dbus_connection_setup_with_g_main(system_dbus, NULL);
	gdk_threads_init ();
	gtk_init (&argc, &argv);
        if(OSSO_OK != osso_rpc_set_default_cb_f(_osso, dbus_cb_default, NULL))
        {
            g_printerr("osso_rpc_set_default_cb_f failed.\n");
            return 1;
        }
	app = app_init ();
	app->gui = ui_init (app);
	gtk_main ();
	osso_deinitialize(_osso);
	exit (EXIT_SUCCESS);
}
