/*
 * This file is part of connection-switcher-plugin
 * Copyright (C) 2008 Kate Alhola
 * Copyright (C) 2009 Kyller Gorgonio
 * Copyright (C) 2009 Marcos Morais
 * Copyright (C) 2008 Nokia Corporation. All rights reserved.
 *
 * Authors: Kyller Gorgonio <kyllercg@gmail.com>
 *          Marcos Morais <morais@embedded.ufcg.edu.br>
 *          Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef _CS_STATUS_BAR_H_
#define _CS_STATUS_BAR_H_

#include <glib.h>
#include <gtk/gtk.h>
#include <libhildondesktop/statusbar-item.h>
#include <libosso.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

G_BEGIN_DECLS

/* Every plugin has a constant priority */
#define CS_STATUS_BAR_PRIORITY              1
#define CS_STATUS_BAR_ICON_SIZE             40
#define CS_IP_DIALOG_ACCEPT                 99
#define CS_STATUS_BAR_BORDER_WIDTH          20
#define CS_STATUS_BAR_MENU_Y_POS            60

typedef struct _CsStatusBar CsStatusBar;
typedef struct _CsStatusBarClass CsStatusBarClass;

#define CS_STATUS_BAR_TYPE                  (cs_status_bar_get_type ())
#define CS_STATUS_BAR(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CS_STATUS_BAR_TYPE, CsStatusBar))
#define CS_STATUS_BAR_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass),  CS_STATUS_BAR_TYPE, CsStatusBarClass))
#define IS_CS_STATUS_BAR(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CS_STATUS_BAR_TYPE))
#define IS_CS_STATUS_BAR_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass),  CS_STATUS_BAR_TYPE))
#define CS_STATUS_BAR_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj),  CS_STATUS_BAR_TYPE, CsStatusBarClass))

struct _CsStatusBar
{
    StatusbarItem parent;
};

struct _CsStatusBarClass
{
    StatusbarItemClass parent_class;
};

GType cs_status_bar_get_type (void);

G_END_DECLS

#endif
