#!/bin/sh

CONFIG=/home/user/.config/feedcircuit/config
CACHE_PATH=`grep 'cache path' $CONFIG | cut -d = -f 2`

STORE_PATH=$1
if [ -z "$STORE_PATH" ]; then
  STORE_PATH=$CACHE_PATH
fi

TMP_PATH=$STORE_PATH/tmp
test ! -d $TMP_PATH && mkdir $TMP_PATH 

cat $CONFIG | while read K; do
     TMP_URL=`echo $K | grep ^url | cut -d = -f 2`;
     test ! -z "$TMP_URL" && URL=$TMP_URL;
     TMP_ID=`echo $K | grep '\[.*\]' | grep -v global | sed -e "s/\]//g;s/\[//g"`;
     test ! -z "$TMP_ID" && ID=$TMP_ID;
     
     if [[ ! -z "$URL" -a ! -z "$ID" ]]; then
         echo "$ID: $URL";
         /usr/bin/feedcircuit-cli -p $TMP_PATH $URL
         mv "`/usr/bin/find $TMP_PATH/*.html | head -n 1`" $STORE_PATH/$ID.html

         unset URL ID;
     fi;
done

rmdir $TMP_PATH