#!/bin/sh

# Local dir where are stored MaemoPad+ DB files
DB_DIR=$1

# Host (can be either hostname, or IP address) which is a receiver of our backup
#  - Can be: HOST, or username@HOST
#  - Before using make sure:
#     * Remote host has enabled SSH server
#     * Remote host has your public key
DST_HOST=$2

# Remote host's dir to store our backup
DST_DIR=$3

# Remote host's custom port
SSH_PORT=$4

# Check that we get all required arguments
test -n "$DB_DIR" && exit 1
test -n "$DST_HOST" && exit 1
test -n "$DST_DIR" && exit 1
test -n "$SSH_PORT" && SSH_PORT=22

# Make backup!
for db in $DB_DIR/*.db; do
    scp $db $DST_HOST:$DST_DIR
