/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#include "const.h"
#include "common.h"
#include "appdata.h"
#include "types.h"
#include "ui.h"
#include "ui-utils.h"
#include "debug.h"
#include "cellrendererpixbuf.h"

#include <gtk/gtk.h>

#ifdef MAEMO
  #include <hildon/hildon.h>
#endif

// TODO: wrap to translation macroses
// TODO: set GTK_SELECTION_BROWSE to all views -> remove checks for selection
//                                                and toolbuttons disabling
/*
#define GETTEXT_PACKAGE "gtk20"
#include <glib/gi18n-lib.h>
*/

#define W(wdg)  (app_data->wdg)

static void create_ap_toolbar(GtkWidget*, AppData_s*);
static void create_cmd_toolbar(GtkWidget*, AppData_s*);
static void create_main_toolbar(GtkWidget*, AppData_s*);
static void init_stock_icons();


AppData_s* new_app_data()
{
    AppData_s* app_data = g_new(AppData_s, 1);

    W(ap.currentIter) = NULL;
    W(changed) = FALSE;
    W(cmd.changed) = FALSE;
#ifdef MAEMO
    W(fullscreen) = FALSE;
#endif

    return app_data;
}

void free_app_data(AppData_s* app_data)
{
    if (!app_data)
        return;

    if (W(ap.currentIter))
        gtk_tree_iter_free(W(ap.currentIter));

    g_free(app_data);
}

// TODO: this function is too long
void create_main_view(AppData_s* app_data)
{
    GtkWidget* hpaned = gtk_hpaned_new();
    GtkWidget* left_frame = gtk_frame_new("");
    GtkWidget* ap_vbox = gtk_vbox_new(FALSE, 0);
    GtkWidget* cmd_vbox = gtk_vbox_new(FALSE, 0);
    GtkWidget* ap_label = make_label_with_markup("<b>AP:</b>");
    GtkWidget* cmd_label = make_label_with_markup("<b>Commands:</b>");
    GtkWidget* ap_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    GtkWidget* cmd_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    GtkWidget* right_frame = gtk_frame_new("");
    GtkWidget* main_vbox = gtk_vbox_new(FALSE, 0);
    GtkWidget* toolbar_hbox = gtk_hbox_new(FALSE, 0);

    /* Main Window */
#ifdef MAEMO
    W(program) = HILDON_PROGRAM(hildon_program_get_instance());
    W(mainWindow) = HILDON_WINDOW(hildon_window_new());
#else
    W(mainWindow) = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#endif

    gtk_container_set_border_width(GTK_CONTAINER(W(mainWindow)), 10);
#ifndef MAEMO
    gtk_window_set_default_size(GTK_WINDOW(W(mainWindow)), 700, 300);
#endif
    gtk_container_add(GTK_CONTAINER(W(mainWindow)), main_vbox);

    /* Frames */
    gtk_box_pack_start(GTK_BOX(main_vbox), hpaned, TRUE, TRUE, 0);
    gtk_paned_add1(GTK_PANED(hpaned), left_frame);
    gtk_paned_add2(GTK_PANED(hpaned), right_frame);
    gtk_frame_set_shadow_type(GTK_FRAME(left_frame), GTK_SHADOW_IN);
    gtk_frame_set_shadow_type(GTK_FRAME(right_frame), GTK_SHADOW_IN);
    /* Set initial size for the left frame */
    gtk_widget_set_size_request(left_frame, 125, -1);

    /* AP List */
    W(apListView) = gtk_tree_view_new();
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(W(apListView)), FALSE);
    gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(W(apListView)), FALSE);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ap_scrolled_window),
                                          W(apListView));
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ap_scrolled_window),
                                   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    /* Set a horizontal alignment of AP label to right */
    g_object_set(ap_label, "xalign", 0.05, NULL);
#ifdef MAEMO
/* Disabled until finger-friendly interfaces is developed */
//     hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(ap_scrolled_window),
//                                       TRUE);
#endif
    gtk_box_pack_start(GTK_BOX(ap_vbox), ap_label, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(ap_vbox), ap_scrolled_window, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(left_frame), ap_vbox);

    /* Command List */
    W(commandListView) = gtk_tree_view_new();
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(W(commandListView)), FALSE);
    gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(W(commandListView)), FALSE);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(cmd_scrolled_window),
                                          W(commandListView));
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(cmd_scrolled_window),
                                   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    /* Set a horizontal alignment of Cmd label to right */
    g_object_set(cmd_label, "xalign", 0.01, NULL);
#ifdef MAEMO
/* Disabled until finger-friendly interfaces is developed */
//     hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(cmd_scrolled_window),
//                                       TRUE);
#endif
    gtk_box_pack_start(GTK_BOX(cmd_vbox), cmd_label, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(cmd_vbox), cmd_scrolled_window, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(right_frame), cmd_vbox);

    /* Toolbar */
    gtk_box_pack_end(GTK_BOX(main_vbox), toolbar_hbox, FALSE, TRUE, 0);
    create_ap_toolbar(toolbar_hbox, app_data);
    create_cmd_toolbar(toolbar_hbox, app_data);
    create_main_toolbar(toolbar_hbox, app_data);

#ifdef MAEMO
    hildon_program_add_window(W(program), W(mainWindow));
#endif

    init_stock_icons();
}

static void create_ap_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();
    GtkToolItem* tool_button_sep = NULL;

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
//    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_BUTTON);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);  

    W(ap.disableToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_CONNECT);
    W(ap.addToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_ADD);
    W(ap.delToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_REMOVE);
    W(ap.renameToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_CONVERT);
    tool_button_sep = gtk_separator_tool_item_new();

    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.disableToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.addToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.delToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.renameToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), tool_button_sep, -1);

    gtk_box_pack_start(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));
    //
    /*
    GtkWidget* button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_button_set_label(GTK_BUTTON(button), "");
    gtk_box_pack_start(GTK_BOX(toolbar_hbox), button, TRUE, TRUE, 0); */
}

static void create_cmd_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);  

    W(cmd.editToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_EDIT);
    W(cmd.moveUpToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_GO_UP);
    W(cmd.moveDownToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_GO_DOWN);
    W(cmd.addToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_NEW); 
    W(cmd.delToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_DELETE);

    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.editToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.moveUpToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.moveDownToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.addToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.delToolButton), -1);

    gtk_box_pack_start(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));

}

static void create_main_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();
    GtkToolItem* empty_tool_item = gtk_tool_item_new();

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);

    W(helpToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_HELP);
#ifndef MAEMO
    gtk_widget_set_sensitive(GTK_WIDGET(W(helpToolButton)), FALSE);
#endif
    W(applyToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_APPLY);
    W(quitToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_QUIT);

    gtk_tool_item_set_expand(empty_tool_item, TRUE);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), empty_tool_item, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(helpToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(applyToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(quitToolButton), -1);

    gtk_box_pack_end(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));

}

static void init_stock_icons()
{
    static GtkStockItem stock_items[] = {
	{ ENB_SUPERUSER_ENV_STOCK, NULL },
	{ DSB_SUPERUSER_ENV_STOCK, NULL },
	{ ENB_COMMAND_STOCK, NULL },
	{ DSB_COMMAND_STOCK, NULL }
    };

    GtkIconFactory* icon_factory = gtk_icon_factory_new();

    gtk_icon_factory_add_default(icon_factory);
    g_object_unref(icon_factory);

    for (gint i = 0; i < G_N_ELEMENTS(stock_items); ++i) {
	gchar* pixmap_path;
	GdkPixbuf* pixbuf;
	GtkIconSet* icon_set;

	pixmap_path = g_strdup_printf(PIXMAP_DIR "/%s.png",
				      stock_items[i].stock_id);
	pixbuf = gdk_pixbuf_new_from_file(pixmap_path, NULL);

	icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
	gtk_icon_factory_add(icon_factory,
			     stock_items[i].stock_id,
			     icon_set);

	gtk_icon_set_unref(icon_set);
	g_object_unref(pixbuf);
	g_free(pixmap_path);
    }

}


/* Access Points */
static void active_ap_cell_func(GtkTreeViewColumn* column,
                                GtkCellRenderer* cell,
                                GtkTreeModel* model,
                                GtkTreeIter* iter,
                                gpointer data)
{
    AccessPoint_s* ap;

    gtk_tree_model_get(model, iter, 0, &ap, -1);
    SET_STOCK_ICON(cell, ap->disabled, NO, YES);

    free_access_point(ap);
}

static void name_ap_cell_func(GtkTreeViewColumn* column,
                              GtkCellRenderer* cell,
                              GtkTreeModel* model,
                              GtkTreeIter* iter,
                              gpointer data)
{
    AccessPoint_s* ap;

    gtk_tree_model_get(model, iter, 0, &ap, -1);
    g_object_set(cell, "text", ap->name, NULL);

    free_access_point(ap);
}

void create_ap_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;
    GtkTreeSelection* selection;

    W(ap.enabledCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(apListView)),
                                     -1,
                                     "Active",
                                     W(ap.enabledCellRndr),
                                     (GtkTreeCellDataFunc)active_ap_cell_func,
                                     NULL, NULL);

    W(ap.nameCellRndr) = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(apListView)),
                                     -1,
                                     "Name",
                                     W(ap.nameCellRndr),
                                     (GtkTreeCellDataFunc)name_ap_cell_func,
                                     NULL, NULL);

    list_store = gtk_list_store_new(1, ACCESS_POINT_TYPE);
    gtk_tree_view_set_model(GTK_TREE_VIEW(W(apListView)),
                            GTK_TREE_MODEL(list_store));

    /* Forbid to make a zero selection */
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(W(apListView)));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);

    g_object_unref(list_store);
}

void fill_ap_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;

    list_store = GTK_LIST_STORE(gtk_tree_view_get_model(
                                    GTK_TREE_VIEW(W(apListView))));

    for (GSList* iter = W(access_points); iter;
                                          iter = g_slist_next(iter)) {
        GtkTreeIter ap_iter;

        gtk_list_store_append(list_store, &ap_iter);
        gtk_list_store_set(list_store, &ap_iter, 0, iter->data, -1);
    }
}

/* Commands */
static void cmdline_cell_func(GtkTreeViewColumn* column,
                              GtkCellRenderer* cell,
                              GtkTreeModel* model,
                              GtkTreeIter* iter,
                              gpointer data)
{
    Command_s* cmd;

    gtk_tree_model_get(model, iter, 0, &cmd, -1);
    g_object_set(cell, "text", cmd->command, NULL);

    free_command(cmd);
}

static void active_cmd_cell_func(GtkTreeViewColumn* column,
                                 GtkCellRenderer* cell,
                                 GtkTreeModel* model,
                                 GtkTreeIter* iter,
                                 gpointer data)
{
    Command_s* cmd;

    gtk_tree_model_get(model, iter, 0, &cmd, -1);
    g_object_set(cell, "stock-id", cmd->disabled ?
		 DSB_COMMAND_STOCK : ENB_COMMAND_STOCK, NULL);

    free_command(cmd);
}

static void superuser_cmd_cell_func(GtkTreeViewColumn* column,
                                    GtkCellRenderer* cell,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter,
                                    gpointer data)
{
    Command_s* cmd;

    gtk_tree_model_get(model, iter, 0, &cmd, -1);
    g_object_set(cell, "stock-id", cmd->superuser_env ?
		 ENB_SUPERUSER_ENV_STOCK : DSB_SUPERUSER_ENV_STOCK, NULL);

    free_command(cmd);
}

void create_cmd_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;
    GtkTreeViewColumn* column;

    W(cmd.disabledCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                    -1,
                                    "Disabled",
                                    W(cmd.disabledCellRndr),
                                    (GtkTreeCellDataFunc)active_cmd_cell_func,
                                    NULL, NULL);

    W(cmd.superuserCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                    -1,
                                    "Superuser Env",
                                    W(cmd.superuserCellRndr),
                                    (GtkTreeCellDataFunc)superuser_cmd_cell_func,
                                    NULL, NULL);


    W(cmd.cmdlineCellRndr) = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                      -1,
                                      "Command",
                                      W(cmd.cmdlineCellRndr),
                                      (GtkTreeCellDataFunc)cmdline_cell_func,
                                      NULL, NULL);

    g_object_set(G_OBJECT(W(cmd.cmdlineCellRndr)), "is-expanded", TRUE, NULL);
    column = gtk_tree_view_get_column(GTK_TREE_VIEW(W(commandListView)), 2);
    gtk_tree_view_column_set_expand(column, TRUE);

    list_store = gtk_list_store_new(1, COMMAND_TYPE);
    gtk_tree_view_set_model(GTK_TREE_VIEW(W(commandListView)),
                            GTK_TREE_MODEL(list_store));

    g_object_unref(list_store);
}

// TODO: more appropriate name, e.g. 'fill_cmd_list_store'
void fill_cmd_list_view(GtkListStore* store, GSList* commands)
{
    gtk_list_store_clear(store);

    for (GSList* iter = commands; iter; iter = g_slist_next(iter)) {
        GtkTreeIter cmd_iter;

        gtk_list_store_append(store, &cmd_iter);
        DBG(" cmd = %s\n", CMD_LIST_CAST(iter)->command);
        gtk_list_store_set(store, &cmd_iter, 0, iter->data, -1);
    }
}

#define DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(TYPENAME, TYPE)       \
GSList* get_ ## TYPENAME ## _gslist_from_model(GtkTreeModel* model) \
{                                                                   \
    GtkTreeIter iter;                                               \
    GSList* list = NULL;                                            \
                                                                    \
    if (!gtk_tree_model_get_iter_first(model, &iter))               \
        return NULL;                                                \
                                                                    \
    do {                                                            \
        TYPE* value = NULL;                                         \
                                                                    \
        gtk_tree_model_get(model, &iter, 0, &value, -1);            \
        APPEND2SLIST(list, value);                                  \
                                                                    \
    } while (gtk_tree_model_iter_next(model, &iter));               \
                                                                    \
    return list;                                                    \
}

DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(cmd, Command_s)
DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(ap, AccessPoint_s)

#define DEFINE_INVERSE_XXX_FIELD_FUNC(NAME, FIELD, TYPE, FREE, VIEW)        \
void inverse_ ## NAME ## _ ## FIELD ## _field(gchar* path_string,           \
                                              gpointer data,                \
                                              gboolean* new_value)          \
{                                                                           \
    GET_APP_DATA(data);                                                     \
                                                                            \
    GtkTreeIter iter;                                                       \
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(W(VIEW)));  \
    GtkTreePath* path = gtk_tree_path_new_from_string(path_string);         \
                                                                            \
    if (!gtk_tree_model_get_iter(model, &iter, path))                       \
	ccreturn("Can't get the iter");                                     \
                                                                            \
    TYPE* obj;                                                              \
    gtk_tree_model_get(model, &iter, 0, &obj, -1);                          \
    obj->FIELD = !obj->FIELD;                                               \
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, obj, -1);           \
                                                                            \
    if (new_value)                                                          \
	*new_value = obj->FIELD;                                            \
                                                                            \
    /* Because of 'cpp' limitations it is not possible                      \
       to use free_ ## NAME ## (obj) instead                                \
    */                                                                      \
    FREE(obj);                                                              \
    gtk_tree_path_free(path);                                               \
}

DEFINE_INVERSE_XXX_FIELD_FUNC(ap, disabled, AccessPoint_s,\
			      free_access_point, apListView)
DEFINE_INVERSE_XXX_FIELD_FUNC(cmd, disabled, Command_s,\
                              free_command, commandListView)
DEFINE_INVERSE_XXX_FIELD_FUNC(cmd, superuser_env, Command_s,\
			      free_command, commandListView)

void enable_cmd_toolbuttons(AppData_s* app_data, gboolean enable)
{
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveUpToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveDownToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.addToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.delToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.editToolButton)), enable);
}

/* Only 'add' button should always be enabled */
void enable_ap_general_toolbuttons(AppData_s* app_data, gboolean enable)
{
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.delToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.disableToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.renameToolButton)), enable);
}

void select_treeview_row(GtkWidget* tree_view, GtkTreeIter* iter)
{
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(tree_view));
    GtkTreePath* path = gtk_tree_model_get_path(model, iter);

    DBG2("select-tree-view-row()");
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(tree_view), path, NULL, FALSE);

    gtk_tree_path_free(path);
}

gboolean show_add_ap_dialog(GtkWindow* parent,
			    const gboolean edit,
			    AccessPoint_s** ap)
{
    GtkWidget* dialog;
    GtkWidget* input_hbox = gtk_hbox_new(FALSE, 0);
    GtkWidget* label = gtk_label_new_with_mnemonic("_Name:");
    GtkWidget* input_entry = gtk_entry_new();
    gboolean disabled = edit ? (*ap)->disabled : FALSE;
    GtkWidget* disabled_check_button = make_check_button(
	                                        "_Disabled",
						disabled);
    if (edit)
	gtk_entry_set_text(GTK_ENTRY(input_entry), (*ap)->name);

    gtk_label_set_mnemonic_widget(GTK_LABEL(label), input_entry);
    gtk_box_pack_start(GTK_BOX(input_hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(input_hbox), input_entry, TRUE, TRUE, 0);

    dialog = show_add_or_edit_entity_basic_dialog(parent,
						  edit ? "Rename AP" : "New AP",
						  edit ? "_Rename" : "_Add",
						  "_Cancel",
						  input_hbox,
						  disabled_check_button,
						  NULL);

    gtk_widget_show_all(dialog);
    gint response = gtk_dialog_run(GTK_DIALOG(dialog));
    gchar* ap_name = (gchar *)gtk_entry_get_text(GTK_ENTRY(input_entry));
    if (GTK_RESPONSE_OK != response || !g_utf8_strlen(ap_name, -1)) {
	gtk_widget_destroy(dialog);
	return FALSE;
    }

    if (!edit)
	*ap = g_new(AccessPoint_s, 1);

    (*ap)->name = g_strdup(ap_name);
    (*ap)->disabled = gtk_toggle_button_get_active(
                    	         GTK_TOGGLE_BUTTON(disabled_check_button));
    if (!edit)
	(*ap)->commands = NULL;

    gtk_widget_destroy(dialog);

    return TRUE;
}


gboolean show_add_command_dialog(GtkWindow* parent,
				 const gboolean edit,
				 Command_s** cmd)
{
    GtkWidget* dialog;
    GtkWidget* input_hbox = gtk_hbox_new(FALSE, 0);
    GtkWidget* label = gtk_label_new_with_mnemonic("Co_mmand:");
    GtkWidget* input_entry = gtk_entry_new();
    gboolean disabled = edit ? (*cmd)->disabled : FALSE;
    gboolean superuser_env = edit ? (*cmd)->superuser_env : FALSE;
    GtkWidget* disabled_check_button = make_check_button(
	                                        "_Disabled",
						disabled);
    GtkWidget* superuser_env_check_button = make_check_button(
	                                        "_Run as superuser",
						superuser_env);

    if (edit)
	gtk_entry_set_text(GTK_ENTRY(input_entry), (*cmd)->command);

    gtk_label_set_mnemonic_widget(GTK_LABEL(label), input_entry);
    gtk_box_pack_start(GTK_BOX(input_hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(input_hbox), input_entry, TRUE, TRUE, 0);

    dialog = show_add_or_edit_entity_basic_dialog(parent,
					  edit ? "Edit Command" : "New Command",
					  edit ? "_Edit" : "_Add",
					  "_Cancel",
				          input_hbox,
				          disabled_check_button,
					  superuser_env_check_button,
				          NULL);

    /* Extend dialog's width to extend input_hbox's width */
    resize_window_by_delta(GTK_WINDOW(dialog), 175, 0);

    gtk_widget_show_all(dialog);
    gint response = gtk_dialog_run(GTK_DIALOG(dialog));
    gchar* command = (gchar *)gtk_entry_get_text(GTK_ENTRY(input_entry));
    if (GTK_RESPONSE_OK != response || !g_utf8_strlen(command, -1)) {
	gtk_widget_destroy(dialog);
	return FALSE;
    }

    if (!edit)
	*cmd = g_new(Command_s, 1);

    (*cmd)->command = g_strdup(command);
    (*cmd)->disabled = gtk_toggle_button_get_active(
                    	         GTK_TOGGLE_BUTTON(disabled_check_button));
    (*cmd)->superuser_env = gtk_toggle_button_get_active(
                  	         GTK_TOGGLE_BUTTON(superuser_env_check_button));

    gtk_widget_destroy(dialog);

    return TRUE;
}



