/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef CONLER_GUI
#include "types.h"
#include "common.h"

#include <glib-object.h>

GType access_point_get_type()
{
    static GType type = 0;

    if (!type)
        type = g_boxed_type_register_static("AccessPoint",
                                            (GBoxedCopyFunc)copy_access_point,
                                            (GBoxedFreeFunc)free_access_point);

    return type;
}

GType command_get_type()
{
    static GType type = 0;

    if (!type)
        type = g_boxed_type_register_static("Command",
                                            (GBoxedCopyFunc)copy_command,
                                            (GBoxedFreeFunc)free_command);

    return type;
}
#endif

