// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#ifndef _CONLER_UI_UTILS_H
#define _CONLER_UI_UTILS_H

#include <gtk/gtk.h>

gboolean is_next_tree_iter_sibling(GtkTreeModel*, GtkTreeIter*);
gboolean is_prev_tree_iter_sibling(GtkTreeModel*, GtkTreeIter*);
GtkTreeIter* get_next_tree_iter(GtkTreeModel*, GtkTreeIter*);
GtkTreeIter* get_prev_tree_iter(GtkTreeModel*, GtkTreeIter*);
gchar* tree_iter_to_path_string(GtkTreeModel*, GtkTreeIter*);
gboolean path_string_to_tree_iter(GtkTreeModel*, gchar*, GtkTreeIter*);
gboolean swap_list_store_items(GtkTreeModel*, GtkTreeIter*, const gboolean);


gchar* show_add_entity_input_dialog(GtkWindow*, gboolean, const gchar*,
                                    const gchar*, const gchar*);
void emit_signal_to_selected_cell(GtkTreeView*, GtkCellRenderer*,
                                  const gchar*, gpointer data);


#define SET_STOCK_ICON(obj, condition, icon1, icon2) \
  g_object_set(obj, "stock-id", (condition) ? GTK_STOCK_ ## icon1 :\
                                              GTK_STOCK_ ## icon2, NULL)


#endif

