// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#ifndef _CONLER_TYPES_H
#define _CONLER_TYPES_H

#include <glib/gslist.h>

#ifdef CONLER_GUI
    // GType definition
    #include <glib-object.h>
#endif

typedef enum
{
    UNKNOWN_VERSION = 0,
    CHINOOK,
    DIABLO
} MaemoVersion;

typedef struct
{
    gchar* version; 
    GSList* access_points;   // List of Wi-Fi Access Points

} ConlerCfg_s;


typedef struct
{
    gchar* name;
    gboolean disabled;
    GSList* commands;

} AccessPoint_s;


#ifdef CONLER_GUI
  #define ACCESS_POINT_TYPE   access_point_get_type()

  GType access_point_get_type();
#endif


#endif

