/*
 * garchivereader.h - routines to abstract archive reading logic
 *
 * Copyright (C) 2008 Benoit Goudreault-Emond (bgoudreaultemond@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __G_ARCHIVE_READER_H__
#define __G_ARCHIVE_READER_H__

#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdio.h>

#include "support.h"

G_BEGIN_DECLS

#define G_TYPE_ARCHIVE_READER            (g_archive_reader_get_type())
#define G_ARCHIVE_READER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_ARCHIVE_READER, GArchiveReader))
#define G_ARCHIVE_READER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_ARCHIVE_READER, GArchiveReaderClass))
#define G_IS_ARCHIVE_READER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_ARCHIVE_READER))
#define G_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_ARCHIVE_READER))
#define G_ARCHIVE_READER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_INTERFACE((obj), G_TYPE_ARCHIVE_READER, GArchiveReaderClass))

typedef struct _GArchiveReader GArchiveReader;
typedef struct _GArchiveReaderClass GArchiveReaderClass;

typedef struct {
    int	  offs,		/* Offset to the signature */
	  len,		/* Signature length */
	  fn_offs;
    char *sign;		/* Signature to compare to */
} magic_sign;

struct _GArchiveReaderClass
{
    GTypeInterface parent;
    int            (*register_path)      (GArchiveReader* reader,
					  const gchar* path);
    GArray*        (*get_file_list)      (GArchiveReader* reader);
    GdkPixbuf*     (*get_page)           (GArchiveReader* reader,
					  int page_number,
					  gdouble* w,
					  gdouble* h);
    gchar*         (*get_last_error)     (GArchiveReader* reader);
};

GType       g_archive_reader_get_type (void) G_GNUC_CONST;

/* methods */

int         g_archive_reader_register_path(GArchiveReader* reader,
					   const gchar* path);

GArray*     g_archive_reader_get_file_list(GArchiveReader* reader);

GdkPixbuf*  g_archive_reader_get_page     (GArchiveReader* reader,
					   int page_number,
					   gdouble* w,
					   gdouble* h);

gchar* g_archive_reader_get_last_error(GArchiveReader* reader);

/* utility routine, placed here for lack of a better place */
int         g_archive_reader_check_magic(const gchar* path,
					 const magic_sign* magic);

G_END_DECLS
#endif
				      
