/*
 *  global.h - auxiliary routines, mainly gp screen management
 *
 *  Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define FOLLOW_TIMER	150

int		ok_dialog(char *ttl, char *msg);

void		initial_setup(void);
void		start_show(void);
void		show_page(int nr);

void		next_page(int adv);
void		previous_page(int prv);
void		goto_begin(void);
void		goto_end(void);
void		file_list_tbtn_clicked(void);

void		update_nav_position(void);
void		install_timer(void);
void		clean_up(void);
void		main_canvas_keyevent(GdkEventKey *event, gboolean is_pressed);
void		main_canvas_buttonpressed(GdkEventButton  *event);
void            main_canvas_buttonreleased(GdkEventButton *event);
void            main_canvas_motion(GdkEventMotion *event);

void		set_zoom_factor(double factor);
void		set_zoom_fit(void);
void		set_zoom_width(void);
void		fit_page(int w, int h);
void		fit_width(int w);
void            rotate(gboolean reset_fit);
void            reset_fit_settings(void);

void            about_box(GtkWidget* main_window);
void            goto_page(GtkWidget* main_window);
void            toggle_fullscreen(void);
void            toggle_keymode(void);
void            toggle_rotation_direction(void);
