/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand.
 *
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with carmand.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __OBD_THREAD_H__
#define __OBD_THREAD_H__

int obd_init(void);

int obd_thread_connect_serial(char *addr);
int obd_thread_connect_bt(char *addr);
int obd_thread_start_simulator(char *file);
int obd_thread_disconnect(void);
const char *obd_thread_connection_status(void);

int obd_thread_add_time_sensor(int pid, int interval);
int obd_thread_del_time_sensor(int pid);
int obd_thread_add_round_sensor(int pid, int interval, int round);
int obd_thread_del_round_sensor(int pid);
int obd_thread_list_dtc(void);

struct obd_sensor_data *obd_thread_get_next(void);

int obd_thread_get_last_data(struct obd_sensor_data **rpm,
			struct obd_sensor_data **speed);

int obd_thread_exit(void);

#endif /* __OBD_THREAD_H__ */
