#!/usr/bin/python
#
#   Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
# 
#   This file is part of carmand.
#   
#   carmand is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   carmand is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 

import gobject

import dbus
import dbus.mainloop.glib

def gps_data_available(mode, lat, lon, alt, track, speed):
    print "DataAvailable(%d, %lf, %lf, %lf, %lf, %lf)" % (mode, lat, lon, alt, track, speed)

def gps_status_changed(status):
    print "StatusChanged(%s)" % status

if __name__ == '__main__':

        print "Filtering GPS signals..."

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

        _dbus_address = "unix:path=/var/run/carmand-dbus-path"
        bus = dbus.bus.BusConnection(_dbus_address)
        # bus = dbus.SystemBus()

        bus.add_signal_receiver(gps_status_changed,
        bus_name = "org.indt.carmand",
        path = "/org/indt/carmand",
        dbus_interface = "org.indt.carmand.GPS",
        signal_name = "StatusChanged")

        bus.add_signal_receiver(gps_data_available,
        bus_name = "org.indt.carmand",
        path = "/org/indt/carmand",
        dbus_interface = "org.indt.carmand.GPS",
        signal_name = "DataAvailable")

        mainloop = gobject.MainLoop()
        mainloop.run()
