/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand.
 *  
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "../src/trip.h"

static void printData(struct trip_data *data)
{
	printf("Time[%u], Lat[%lf], Lon[%lf], Speed[%d], RPM[%d]\n",data->time,
			data->lat, data->lon, data->speed, data->rpm);
}

int main (int argc, char **argv)
{
	char *file = NULL;
	FILE *fp = NULL;
	int i = 0;
	double timestamp;
	double rpm;
	double speed;
	char buf[30];
	struct trip_header header;
	struct trip_data data;

	if (argc < 2) {
		fprintf(stdout, "Ops, Use: %s <file-path>\n", *argv);
		return;
	}
	file = *++argv;

	fprintf(stdout, "Opening file: %s\n", file);
	fp = fopen (file, "rb");
	if (!fp) {
		fprintf(stderr, "Problems opening %s, errno: %d\n", file, errno);
		return;
	}
	fread(&header, sizeof(header), 1, fp);

	printf("### Start[%ld], precision[%ld] ###\n", header.start_time,
			header.precision);
	while (fread(&data, sizeof(data), 1, fp))
	{
		printCData(&data);
	}

	fclose(fp);
}

