/*
 *
 *  carmand - Carman Daemon
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand.
 *
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Foobar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __LOCATION__H__
#define __LOCATION__H__


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

typedef struct {
	double  time;
	int     mode;
	double  speed;
	double  longitude;
	double  latitude;
	double  track;
	double  altitude;
} location_t;

int location_init(void);
void location_exit(void);
int location_connect(const char *addr);
int location_disconnect();
const char *location_status(void);

int gps_get_last_data(location_t **fix);



#endif
