#!/usr/bin/python
#
#   Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
# 
#   This file is part of carmand.
#   
#   carmand is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   carmand is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 

import gobject

import dbus
import dbus.mainloop.glib

def freedesktop_nameownerchanged(name, old, new):
    print "NameOwnerchanged(%s, %s, %s)" % (name, old, new)

def freedesktop_nameacquired(name):
    print "NameAcquired(%s)" % name

if __name__ == '__main__':

        print "Filtering Freedesktop NameOwnerChanged and NameAcquired..."

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

        _dbus_address = "unix:path=/var/run/carmand-dbus-path"
        bus = dbus.bus.BusConnection(_dbus_address)
        # bus = dbus.SystemBus()

        bus.add_signal_receiver(freedesktop_nameownerchanged,
        bus_name = "org.freedesktop.DBus",
        path = "/org/freedesktop/DBus",
        dbus_interface = "org.freedesktop.DBus",
        signal_name = "NameOwnerChanged")

        bus.add_signal_receiver(freedesktop_nameacquired,
        bus_name = "org.freedesktop.DBus",
        path = "/org/freedesktop/DBus",
        dbus_interface = "org.freedesktop.DBus",
        signal_name = "NameAcquired")

        mainloop = gobject.MainLoop()
        mainloop.run()
