/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand.
 *
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Foobar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with carmand.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __DBUS_H__
#define __DBUS_H__


#include <dbus/dbus.h>

#include "location.h"

#define CARMAND_DBUS_PATH "/org/indt/carmand"
#define CARMAND_DBUS_BUS_NAME	"org.indt.carmand"

int dbus_init(DBusConnection *conn, GMainLoop *loop);
void dbus_exit(void);
void dbus_emit_obd_status(const char *signal);
void dbus_emit_obd_data(int pid, double value1, double value2,
			double value3, double value4);
void dbus_emit_gps_status(const char *signal);

void dbus_emit_gps_data(location_t *gps);

void dbus_emit_obd_dtc(GSList *dtc);

void dbus_emit_trip_reseted(void);

#endif
