/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of obdlib.
 *
 *  obdlib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  obdlib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with obdlib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __CARMAND_LOG__H__
#define __CARMAND_LOG__H__

#include <stdio.h>
#include <sys/timeb.h>

typedef enum {
	LOG_ERROR = 1,
	LOG_WARNING = 2,
	LOG_INFO = 4,
	LOG_DEBUG = 8
} carmandloglevel;

FILE* carmandlog_file;
carmandloglevel carmandlog_level;

void carmand_log(int level, char* format, ...);

#define ERROR(fmt...)								\
	do {									\
		if (carmandlog_file != 0 && carmandlog_level >= LOG_ERROR) {	\
			struct timeb tp;					\
			struct timeval t;					\
			char stime[9];						\
			ftime(&tp);						\
			gettimeofday(&t, NULL);					\
			strftime(stime, sizeof(stime),				\
				"%k:%M:%S", localtime(&tp.time));		\
			fprintf(carmandlog_file,				\
					"  ERROR [%s.%06ld] %12s:%04d - ", stime,\
					(long) t.tv_usec, __FILE__, __LINE__); 	\
			fprintf(carmandlog_file, fmt);				\
			fprintf(carmandlog_file, "\n");				\
		}								\
	} while(0)
			

#define WARNING(fmt...)								\
	do {									\
		if (carmandlog_file != 0 && carmandlog_level >= LOG_WARNING) {	\
			struct timeb tp;					\
			struct timeval t;					\
			char stime[9];						\
			ftime(&tp);						\
			gettimeofday(&t, NULL);					\
			strftime(stime, sizeof(stime),				\
				"%k:%M:%S", localtime(&tp.time));		\
			fprintf(carmandlog_file,				\
					"WARNING [%s.%06ld] %12s:%04d - ", stime,\
					(long) t.tv_usec, __FILE__, __LINE__); 	\
			fprintf(carmandlog_file, fmt);				\
			fprintf(carmandlog_file, "\n");				\
		}								\
	} while(0)

#define INFO(fmt...)								\
	do {									\
		if (carmandlog_file != 0 && carmandlog_level >= LOG_INFO) {	\
			struct timeb tp;					\
			struct timeval t;					\
			char stime[9];						\
			ftime(&tp);						\
			gettimeofday(&t, NULL);					\
			strftime(stime, sizeof(stime),				\
				"%k:%M:%S", localtime(&tp.time));		\
			fprintf(carmandlog_file,				\
					"   INFO [%s.%06ld] %12s:%04d - ", stime,\
					(long) t.tv_usec, __FILE__, __LINE__); 	\
			fprintf(carmandlog_file, fmt);				\
			fprintf(carmandlog_file, "\n");				\
		}								\
	} while(0)

#define DEBUG(fmt...) \
	do {									\
		if (carmandlog_file != 0 && carmandlog_level >= LOG_DEBUG) {	\
			struct timeb tp;					\
			struct timeval t;					\
			char stime[9];						\
			ftime(&tp);						\
			gettimeofday(&t, NULL);					\
			strftime(stime, sizeof(stime),				\
				"%k:%M:%S", localtime(&tp.time));		\
			fprintf(carmandlog_file,				\
					"  DEBUG [%s.%06ld] %12s:%04d - ", stime,\
					(long) t.tv_usec, __FILE__, __LINE__); 	\
			fprintf(carmandlog_file, fmt);				\
			fprintf(carmandlog_file, "\n");				\
		}								\
	} while(0)

void carmandlog_setup(FILE* file, carmandloglevel level);

#endif /*__CARMAND_LOG__H__*/
