/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand-panel.
 *
 *  carmand-panel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand-panel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

G_BEGIN_DECLS

#define CARMAND_TYPE_TRAY		(carmand_tray_get_type ())
#define CARMAND_TRAY(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), \
					CARMAND_TYPE_TRAY, CarmandTray))
#define CARMAND_TRAY_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), \
					CARMAND_TYPE_TRAY, CarmandTrayClass))
#define CARMAND_IS_TRAY(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
					CARMAND_TYPE_TRAY))
#define CARMAND_IS_TRAY_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE((k), \
					CARMAND_TYPE_TRAY))
#define CARMAND_TRAY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), \
					CARMAND_TYPE_TRAY, CarmandTrayClass))


typedef struct _CarmandTray		CarmandTray;
typedef struct _CarmandTrayClass	CarmandTrayClass;

struct _CarmandTray
{
	GObject			parent_instance;

	/* instance members */
	HildonProgram *program;
	HildonWindow *window;
	GtkStatusIcon *icon;
	CarmandDbus *dbus;

	GtkWidget *menu;
	GtkWidget *menu_trip_reset;
	GtkWidget *menu_open_carman;
	GtkWidget *menu_trip_settings;
	GtkWidget *menu_quit;

	/* Trip Reset dialog */
	GtkWidget *trip_caption;
	GtkWidget *trip_dialog;
	GtkWidget *trip_check;
	GtkWidget *trip_entry;
};

struct _CarmandTrayClass
{
	GObjectClass		parent_class;
	/* class members */
};

/* GLib API Functions */
GType carmand_tray_get_type(void) G_GNUC_CONST;

G_END_DECLS
