#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carmand-panel.
#
#  carmand-panel is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carmand-panel is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, sys, shutil
sys.path.insert(0, "")
sys.path.append("/usr/share/carman/carman-evas")
sys.path.append("/usr/share/carman/carman-evas/models")
sys.path.append("/usr/share/carman/carman-common")

from models.reposet import RepoBase

def load_repository(directory):
    folder = os.path.dirname(directory)
    name = os.path.basename(directory)
    name = name.split(".")
    name = name[0]

    try:
        test = os.path.join(folder, name)
        module = __import__(test)
        repo = module.get_repository()
        if isinstance(repo, RepoBase):
            aux = repo.get_name()
            return aux
        else:
            print("repository %s invalid for maps")
            return "None"
    except ImportError, err:
        print("Could not load %s repository" % name)
        return "None"
    except AttributeError, err:
        print("Invalid repository: %s" % repo.__name__)

def copy_repo_files(source, dest):
    try:
        shutil.copy(source, dest)
        return 1
    except IOError, err:
        print ("Could not find %s file" % err.filename)
        return 0
