import os, sys, shutil

sys.path.append("/usr/share/carman/carman-evas")
from models.reposet import RepoBase

cdef public char *load_repo(char *filename):
    plugin_file = filename.rsplit(".", 1)[0]
    name = os.path.basename(plugin_file)
    if "" not in sys.path:
        sys.path.insert(0, "")

    try:
        module = __import__(plugin_file)
        repo = module.get_repository()
        if isinstance(repo, RepoBase):
            repo_name = repo.get_name()
            return repo_name
    except:
        pass

    return ""

cdef public int copy_files(char *source, char *dest):
    try:
        shutil.copy(source, dest)
        return 1
    except IOError, err:
        print ("Could not find %s file" % err.filename)
        return 0
