import os, sys, shutil
sys.path.insert(0, "")
sys.path.append("/usr/share/carman/carman-evas")
sys.path.append("/usr/share/carman/carman-evas/models")
sys.path.append("/usr/share/carman/carman-common")

from models.reposet import RepoBase

def load_repository(directory):
    folder = os.path.dirname(directory)
    name = os.path.basename(directory)
    name = name.split(".")
    name = name[0]

    try:
        test = os.path.join(folder, name)
        module = __import__(test)
        repo = module.get_repository()
        if isinstance(repo, RepoBase):
            aux = repo.get_name()
            return aux
        else:
            print("repository %s invalid for maps" % name)
            return "None"
    except ImportError, err:
        print("Could not load %s repository" % name)
        return "None"
    except AttributeError, err:
        print("Invalid repository: %s" % repo.__name__)

def copy_repo_files(source, dest):
    try:
        shutil.copy(source, dest)
        return 1
    except IOError, err:
        print ("Could not find %s file" % err.filename)
        return 0
