/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand-panel.
 *
 *  carmand-panel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand-panel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CARMAND_LOGMSG_H
#define CARMAND_LOGMSG_H

#undef		G_LOG_DOMAIN
#define		G_LOG_DOMAIN	"carmand-panel"

/* Message API for Carmand Daemon Panel. */

#define carmand_message(mesg...)	\
	g_message(mesg)

#define carmand_warning(mesg...)	\
	g_warning(mesg)

/* fatal at runtime
 * by setting the G_DEBUG environment variable. */
/* g_error(mesg) - result in a core dump;
 * don't use it for errors you expect. */
#define carmand_error(mesg...)	\
	g_warning(mesg)

#ifdef DEBUG

#define carmand_debug(mesg...)	\
	g_debug(mesg)

#else

#define carmand_debug(mesg...)

#endif

#define carmand_vdebug carmand_debug

#endif /* CARMAND_LOGMSG_H */
