/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand-panel.
 * 
 *  carmand-panel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand-panel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
G_BEGIN_DECLS

#define CARMAND_DBUS_BUS_NAME             "org.indt.carmand"
#define CARMAND_DBUS_OBJECT_PATH          "/org/indt/carmand"
#define CARMAND_DBUS_IFACE_CONFIGURATION  CARMAND_DBUS_BUS_NAME ".Configuration"
#define CARMAND_DBUS_IFACE_GPS		CARMAND_DBUS_BUS_NAME ".GPS"
#define CARMAND_DBUS_IFACE_OBD		CARMAND_DBUS_BUS_NAME ".OBD"
#define CARMAND_DBUS_IFACE_TRIP		CARMAND_DBUS_BUS_NAME ".Trip"


/*
 * Configuration Interface
 */

/* Methods */
#define DBUS_SETPRECISION	"SetTimePrecision"
#define DBUS_SETTRIPSFOLDER	"SetTripsFolder"
#define DBUS_SETMAPSFOLDER	"SetMapsFolder"
#define DBUS_SETTRACKSFOLDER	"SetTracksFolder"
#define DBUS_SETOBD		"SetOBDDevice"
#define DBUS_SETGPS		"SetGPSDevice"
#define DBUS_SETTRIPSENSORS	"SetTripSensors"
#define DBUS_SETMAXTRIP		"SetMaxTripTime"
#define DBUS_SETMODE		"SetMode"

#define DBUS_GETPRECISION	"GetTimePrecision"
#define DBUS_GETTRIPSFOLDER	"GetTripsFolder"
#define DBUS_GETMAPSFOLDER	"GetMapsFolder"
#define DBUS_GETTRACKSFOLDER	"GetTracksFolder"
#define DBUS_GETOBD		"GetOBDDevice"
#define DBUS_GETGPS		"GetGPSDevice"
#define DBUS_GETTRIPSENSORS	"GetTripSensors"
#define DBUS_GETMODE		"GetMode"

#define DBUS_SAVECONF		"SaveConfiguration"
#define DBUS_DISCARDCONF	"DiscardConfiguration"

/* Signals */
#define DBUS_SIGNAL_SAVED	"ConfigurationSaved"
#define DBUS_SIGNAL_DISCARDED	"ConfigurationDiscarded"

/*
 * Service Interface
 */

/* GPS Methods */
#define DBUS_GPS_METHOD_CONNECT		"Connect"
#define DBUS_GPS_METHOD_DISCONNECT	"Disconnect"
#define DBUS_GPS_METHOD_STATUS		"Status"

/* GPS DBus Signals */
#define SIGNAL_GPS_STATUS		"StatusChanged"
#define SIGNAL_GPS_DATAAVAILABLE	"DataAvailable"

/* GPS Status Signal Responses */
#define GPS_SIGNAL_STATUS_FIXING		"Fixing"
#define GPS_SIGNAL_STATUS_FIXED			"Fixed"
#define GPS_SIGNAL_STATUS_CONNECTING		"Connecting"
#define GPS_SIGNAL_STATUS_DISCONNECTED		"Disconnected"

/* OBD Methods */
#define DBUS_OBD_METHOD_CONNECTOBD		"ConnectBT"
#define DBUS_OBD_METHOD_CONNECTOBDSERIAL	"ConnectSerial"
#define DBUS_OBD_METHOD_STARTOBDSIMUL		"StartSimulator"
#define DBUS_OBD_METHOD_DISCONNECTOBD		"Disconnect"
#define DBUS_OBD_METHOD_ISCONNECTED		"isConnected"
#define DBUS_OBD_METHOD_ISCONNECTING		"isConnecting"
#define DBUS_OBD_METHOD_ISDISCONNECTED		"isDisconnected"
#define DBUS_OBD_METHOD_STATUS			"Status"
#define DBUS_OBD_METHOD_ADDTIMESENSOR		"AddTimeSensor"
#define DBUS_OBD_METHOD_DELTIMESENSOR		"DelTimeSensor"
#define DBUS_OBD_METHOD_ADDROUNDSENSOR		"AddRoundSensor"
#define DBUS_OBD_METHOD_DELROUNDSENSOR		"DelRoundSensor"

/* OBD DBus Signals */
#define SIGNAL_OBD_STATUS		"StatusChanged"
#define SIGNAL_OBD_DATAAVAILABLE	"DataAvailable"

/* Trip Methods */
#define DBUS_METHOD_TRIP_FLUSHDATA		"FlushData"
#define DBUS_METHOD_TRIP_RESETRIP		"ResetTrip"
#define DBUS_METHOD_TRIP_ACTUALTRIPFOLDER	"ActualTripFolder"
#define DBUS_METHOD_LASTGPSDATA			"LastGPSData"
#define DBUS_METHOD_LASTOBDDATA			"LastOBDData"

/* Trip DBus Signals */
#define SIGNAL_TRIP_DATAFLUSHED		"DataFlushed"

#define CARMAND_DBUS_

#define CARMAND_TYPE_DBUS		(carmand_dbus_get_type ())
#define CARMAND_DBUS(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), \
					CARMAND_TYPE_DBUS, CarmandDbus))
#define CARMAND_DBUS_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), \
					CARMAND_TYPE_DBUS, CarmandDbusClass))
#define CARMAND_IS_DBUS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
					CARMAND_TYPE_DBUS))
#define CARMAND_IS_DBUS_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE((k), \
					CARMAND_TYPE_DBUS))
#define CARMAND_DBUS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), \
					CARMAND_TYPE_DBUS, CarmandDbusClass))
struct carmand_dbus_cbs {
	void (*gps_statuschanged) (DBusGProxy *proxy, gpointer data);
	void (*obd_statuschanged) (DBusGProxy *proxy, gpointer data);
	void (*bonding_created) (DBusGProxy *object, const gchar *address,
			gpointer data);
	void (*bonding_removed) (DBusGProxy *object, const gchar *address,
			gpointer data);
};

typedef struct _CarmandDbus		CarmandDbus;
typedef struct _CarmandDbusClass	CarmandDbusClass;

struct _CarmandDbus
{
	GObject		parent_instance;
	/* instance members */

	DBusGProxy *proxy_bluetooth;

	DBusGConnection *system_bus;

	DBusConnection *session_bus;
	DBusConnection *private_bus;
	DBusGConnection *g_private_bus;

	DBusGProxy *proxy_gps;
	DBusGProxy *proxy_obd;
	DBusGProxy *proxy_bluez;

	gpointer parent_data;

	struct carmand_dbus_cbs *callbacks;
};

struct _CarmandDbusClass
{
	GObjectClass	parent_class;
	/* class members */
};


/* Carmand-panel Dbus Functions */

void cpanel_dbus_method_call(CarmandDbus *self,
		const gchar *method, const gchar *interface);
gint cpanel_dbus_int_method_call(CarmandDbus *self,
		const gchar *method, const gchar *interface);
gchar *cpanel_dbus_str_method_call(CarmandDbus *self, const gchar *method,
		const gchar *interface, DBusError *derr);
gboolean method_call_string_arg(CarmandDbus *dbus,
		const gchar *method, const gchar *arg);
gboolean method_call_int_arg(CarmandDbus *dbus,
			const gchar *method, gint arg);

/* GLib API Functions */

GType carmand_dbus_get_type(void) G_GNUC_CONST;

CarmandDbus *carmand_dbus_new(gpointer parent_data,
		struct carmand_dbus_cbs *callbacks);

G_END_DECLS
