/*
 *
 * Copyright (C) 2008 Nokia Corporation. All rights reserved.
 *
 * Redistribution  and use  in source  and binary  forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * Redistributions  of source code must retain the above copyright
 * notice, this  list  of conditions and  the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation  and / or other materials  provided  with the
 * distribution. The name of the author may not be used to endorse
 * or promote products derived from this software without specific
 * prior written permission.
 * 
 * THIS SOFTWARE  IS  PROVIDED  BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES  OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE  ARE  DISCLAIMED. IN  NO  EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON  ANY THEORY  OF  LIABILITY, WHETHER  IN  CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define GPS_SIMULATOR_MODE	0x01
#define GPS_CMD_CONNECT		0x02
#define GPS_CMD_DISCONNECT	0x04

enum { 
	GPS_EVT_ERROR,
	GPS_EVT_DISCONNECTED,
	GPS_EVT_CONNECTED,
	GPS_EVT_FIXING,
	GPS_EVT_FIXED
};

typedef struct {
	        guint8          type;
	        guint32         size;
	        guint8          data[0];
} gps_cmd_t, gps_evt_t;

typedef struct {
	double  time;
	int     mode;
	double  speed;
	double  longitude;
	double  latitude;
	double  track;
	double  altitude;
} location_t;

#ifdef LOCATION_ENABLED
int location_init(void);
int location_gps_start(const char *address);
int location_gps_stop(void);
void location_exit(void);
#endif
int simulator_init(void);
int simulator_gps_start(const char *address);
int simulator_gps_stop(void);
void simulator_exit(void);

int send_event(int type, guint8 *data, size_t dsize);
