/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of infosharingd.
 *
 *  infosharingd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  infosharingd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with infosharingd. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __COMMANDS_H__
#define __COMMANDS_H__

/* Account commands */

int account_is_enabled();
int account_is_connected();
int account_is_connecting();
int account_is_disconnected();
gboolean account_is_definded();
int account_exists();
int account_new(char *username, char *protocol_id);
int account_remove();
int set_account_username(char *account);
int set_account_alias(char *alias);
int set_account_password(char *pwd);
int set_account_rem_pwd(gboolean value);
int set_account_protocol_id(char *protocol_id);
char *get_account_username();
char *get_account_protocol_id();
char *get_account_alias();
const char *get_account_password();
gboolean get_account_rem_pwd();
int account_set_active_status(char *type, char *msg);
int account_connect();
int account_disconnect();

/* Buddy commands */

int add_buddy(char *buddy_name, char *buddy_group, char *buddy_alias);
int remove_buddy(char *buddy_name);
int buddy_exists(char *buddy_name);
GSList *get_buddies();
GSList *get_carman_buddies_online();
int get_buddy_presence(char *buddy_name);
const char *get_buddy_alias(char *buddy_name);
int set_buddy_alias(char *buddy_name, char *buddy_alias);

/* Protocol commands */

gboolean protocol_exists(char *protocol_id);
GHashTable *get_protocol_options(char *protocol_id);
GHashTable *get_account_protocol_options();
int set_account_protocol_options(GHashTable *prpl_options);

/* Miscelaneous commands */

int request_authorize_buddy_cb(char *name, gboolean authorize);
int send_im_message(char *name, char *message);

#endif /* __COMMANDS_H__ */
