/*
 * Carman Cleanup
 * Copyright (C) 2008 Instituto Nokia de Tecnologia
 * Author: Gustavo Barbieri <gustavo.barbieri@openbossa.org>
 *         Eduardo Lima (Etrunko) <eduardo.lima@indt.org.br>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ui-impl.h"
#if HILDON_VERSION <= 3
#include <hildon-widgets/hildon-program.h>
#elif HILDON_VERSION == 4
#include <hildon/hildon-program.h>
#endif

GtkWidget *
create_window(void)
{
	return hildon_window_new();
}

UiProgram *
program_new(void)
{
	HildonProgram *p;

	p = hildon_program_get_instance();
	g_set_application_name("Carman Cleanup");
	return (UiProgram *)p;
}

void
program_add_window(UiProgram *program,
		GtkWidget *window)
{
	hildon_program_add_window(HILDON_PROGRAM(program), HILDON_WINDOW(window));
}
