COLOR_GOOD="\033[1;32m"
COLOR_WARN="\033[1;33m"
COLOR_ERROR="\033[1;31m"
COLOR_NORMAL="\033[0m"

# error <message>
error() {
    echo -e " ${COLOR_ERROR}*${COLOR_NORMAL} $*"
    exit 1
}

# warn <message>
warn() {
    echo -e " ${COLOR_WARN}*${COLOR_NORMAL} $*"
}

# msg <message>
msg() {
    echo -e " ${COLOR_GOOD}*${COLOR_NORMAL} $*"
}

# msg_begin <message>
msg_begin() {
    echo -en " ${COLOR_GOOD}*${COLOR_NORMAL} $* ..."
}

# msg_end <error-code>
msg_end() {
    echo -en "\033[72G"
    if [ $1 -eq 0 ]; then
        echo -e "[ ${COLOR_GOOD}ok${COLOR_NORMAL} ]"
    else
        echo -e "[${COLOR_ERROR}fail${COLOR_NORMAL}]"
        exit 1
    fi
}

# compile_py <filename>
compile_py() {
    local CODE
    CODE="import py_compile, sys; py_compile.compile(sys.argv[1], doraise=True)"
    python2.5 -OO -c "$CODE" "$1"
}

# zip_collection_py <base-folder> <file-name-pattern> <path/to/dest.zip>
#   path/to/dest.zip -> must be complete path
zip_collection_py() {
    local i
    OLD=$(pwd)
    cd "$1"
    for i in $2; do
	find -name "$i" | zip -q -0 -@ "$3"
    done
    cd $OLD
}

# create_collection <base-folder> <output-zip>
create_collection() {
    msg "Creating collection $(basename $2)"

    if [ x$NO_OPTIMIZE != x1 ]; then
	msg "   Optimizing Python files:"
	find $1 -name '*.py' | while read file; do
            msg_begin "      compiling $file"
            compile_py $file
            msg_end $?
	done
    fi

    msg "   Compressing collection:"
    msg_begin "      $1 -> `basename $2`"
    zip_collection_py $1 "*.pyo plugins.info" $2
    msg_end $?
}

# plugin_compile_themes <input-folder> <plugin-name> <output-folder>
plugin_compile_themes() {
    msg "Compiling themes for plugin $2"

    OLD=$(pwd)
    cd $1
    themes_dir=$(pwd)
    for theme in *; do
        cd $theme
        msg_begin "      compiling $theme"
        edje_cc "$theme.edc" "$3/$theme-$2.edj"
        msg_end $?
        cd $themes_dir
    done
    cd $OLD
}
