# Canola2 Remember The Milk Plugin
# Authors: Andrey Popelo <andrey@popelo.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import etk
import edje
import os

from terra.core.terra_object import TerraObject
from terra.core.manager import Manager

manager = Manager()
CheckListRenderer = manager.get_class("Widget/CheckListRenderer")
ItemRenderer = manager.get_class("Renderer/EtkList/Item")

###########################################################
# Options
###########################################################

class LabeledEntryItemRenderer(etk.KineticRenderer, TerraObject):
    terra_type = "Renderer/EtkList/LabeledEntryItem"

    def __init__(self, label="", text="", *a, **ka):
        etk.KineticRenderer.__init__(self, *a, **ka)
        self.label = label
        self.text = text
        self.args = a
        self.kargs = ka

    def create_cell(self, canvas):
        self.entry = etk.Entry(text=self.text)

        label = etk.Label(self.label)
        label.alignment_set(0.0, 0.0)

        vbox = etk.VBox()
        vbox.border_width_set(0)
        vbox.append(label, etk.VBox.START, etk.VBox.FILL, 0)
        vbox.append(self.entry, etk.VBox.START, etk.VBox.FILL, 0)

        embed = etk.Embed(canvas)
        embed.add(vbox)
        embed.show_all()

        return embed.object

    def get_text(self):
        return self.entry.text_get()

    def set_text(self, text):
        self.entry.text_set(text)

    def press(self, cell, row):
        pass

    def release(self, cell, row):
        pass

    def update_cell(self, cell, row):
        pass

    def show_cell(self, cell, x, y, w, h):
        cell.resize(w - 40, h - 10)
        cell.move(int(x + 5), int(y + 5))
        cell.show()

class PropertyValueItemRenderer(ItemRenderer):
    terra_type = "Renderer/EtkList/PropertyValueItem"

    def __init__(self, text_func=None, value_func=None, item_click=None, *a, **ka):
        ItemRenderer.__init__(self, text_func=text_func, item_click=item_click, *a, **ka)
        self.value_func = value_func



    def create_cell(self, canvas):
        # FIXME: this is a very dirty and unreliable hack
        themes_dir         = manager.terra_config.themes_dir
        default_conf_theme = os.path.join(themes_dir, "conf.edj")
        rtm_conf_theme     = os.path.join(themes_dir, "default-etk-rtm.edj")

        # inject canola-rtm custom etk theme
        etk.theme_widget_set_from_path(rtm_conf_theme)

        cell = edje.Edje(canvas)
        etk.theme_edje_object_set(cell, self.list.theme_file,
                                  "property_value_item", "canola/conf")

        # restore original etk theme
        etk.theme_widget_set_from_path(default_conf_theme)
        return cell

    def update_cell(self, cell, row):
        cell.part_text_set("property", self.text_func(row))
        if callable(self.value_func):
            cell.part_text_set("value", self.value_func(row))

class CheckListSingleRenderer(CheckListRenderer):
    def _is_selected(self, v):
        parent = v.parent
        return parent.current is not None and \
            parent.children[parent.current] is v
