# Canola2 IM Plugin
# Authors: Thiago Borges Abdnur <bolaum@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import dbus

from telepathy.constants import *

config_defaults = {
    'GTalk' : {
        'manager'   :   'gabble',
        'protocol'  :   'jabber',
        'options'   :   {
            'account'   :   '',
            'password'  :   '',
            'server'    :   'talk.google.com',
            'port'      :   dbus.UInt32(5223),
            'old-ssl'   :   True,
            'require-encryption'    :   True
        }
    },
    'MSN' : {
        'manager'   :   'haze',
        'protocol'  :   'msn',
        'options'   :   {
            'account'   :   '',
            'password'  :   ''
        }
    },
    'ICQ' : {
        'manager'   :   'haze',
        'protocol'  :   'icq',
        'options'   :   {
            'account'   :   '',
            'password'  :   ''
        }
    },
    'Yahoo' : {
        'manager'   :   'haze',
        'protocol'  :   'yahoo',
        'options'   :   {
            'account'   :   '',
            'password'  :   ''
        }
    },
    'AIM' : {
        'manager'   :   'haze',
        'protocol'  :   'aim',
        'options'   :   {
            'account'   :   '',
            'password'  :   ''
        }
    },
    'Bonjour' : {
        'manager'   :   'salut',
        'protocol'  :   'local-xmpp',
        'options'   :   {
            'first-name':   '',
            'last-name' :   '',
            'nickname'  :   '',
            'email'     :   ''
        }
    }
}

Protocol_Login_Labels = {
    'GTalk' : 'Gmail account',
    'MSN' : 'E-mail',
    'ICQ' : 'UIN',
    'Yahoo' : 'Yahoo! ID',
    'AIM' : 'Screen Name'
}

Connection_Status_Reason = {
    CONNECTION_STATUS_REASON_NONE_SPECIFIED : "No reason given",
    CONNECTION_STATUS_REASON_NETWORK_ERROR : "Network error",
    "NetworkError" : "Network error",
    CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED : "Authentication failed",
    "AuthenticationFailed" : "Authentication failed",
    CONNECTION_STATUS_REASON_ENCRYPTION_ERROR : "Encryption error",
    CONNECTION_STATUS_REASON_NAME_IN_USE : "Name already in use",
    "NotAvailable" : "Service already in use"
}

status_identifiers = {
    "available" : {"str" : "Available", "type" : CONNECTION_PRESENCE_TYPE_AVAILABLE },
    "away" : {"str" : "Away", "type" : CONNECTION_PRESENCE_TYPE_AWAY },
    "brb" : {"str" : "Be right back", "type" : CONNECTION_PRESENCE_TYPE_AWAY },
    "dnd" : {"str" : "Do Not Disturb", "type" : CONNECTION_PRESENCE_TYPE_BUSY },
    "busy" : {"str" : "Busy", "type" : CONNECTION_PRESENCE_TYPE_BUSY },
    "xa" : {"str" : "Extended away", "type" : CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY },
    "hidden" : {"str" : "Invisible", "type" : CONNECTION_PRESENCE_TYPE_HIDDEN },
    "offline" : {"str" : "Offline", "type" : CONNECTION_PRESENCE_TYPE_OFFLINE },
    "unknown" : {"str" : "Offline", "type" : CONNECTION_PRESENCE_TYPE_UNKNOWN },
    "error" : {"str" : "Offline", "type" : CONNECTION_PRESENCE_TYPE_ERROR }
}
