# Canola2 IM Plugin
# Authors: Thiago Borges Abdnur <bolaum@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import pdb

import logging

import ecore
import textwrap
import etk

from terra.core.manager import Manager

from backend import Backend, Account, BonjourAccount
from constants import Protocol_Login_Labels

manager = Manager()
be = Backend()

ListPanel = manager.get_class("Widget/ListPanel")
ListPanelController = manager.get_class("Controller/Settings/Folder")
RowRendererWidget = manager.get_class("Widget/RowRenderer")
PanelContentModal = manager.get_class("Widget/Settings/PanelContentModal")
UsernamePasswordModal = manager.get_class("Widget/Settings/UsernamePasswordModal")
EntryModal = manager.get_class("Widget/Settings/EntryModal")
MessageModal = manager.get_class("Widget/Settings/MessageModal")
ModalController = manager.get_class("Controller/Modal")

log = logging.getLogger("plugins.canola-im.options")


class OptionsHeaderItemRenderer(RowRendererWidget):
    row_group = "panel_list_item_text"

    def __init__(self, parent, theme=None):
        RowRendererWidget.__init__(self, parent, theme)

    def do_value_set(self, v):
        self.part_text_set("text", v.name)
        self._model = v


class OptionsHeaderFolderPanel(ListPanel):
    def __init__(self, main_window, title, header_text, elements, theme=None):
        ListPanel.__init__(self, main_window, title, elements,
                        OptionsHeaderItemRenderer,
                        theme=theme, header_text=header_text)

class LoginPasswordModal(UsernamePasswordModal):
    def __init__(self, protocol, parent, title,
                 theme=None, hborder=16, vborder=50):
        PanelContentModal.__init__(self, parent, title, theme,
                                hborder=hborder, vborder=vborder)

        label_username = etk.Label(Protocol_Login_Labels[protocol] + ':')
        label_username.alignment_set(0.0, 1.0)
        label_username.show()

        label_password = etk.Label("Password:")
        label_password.alignment_set(0.0, 1.0)
        label_password.show()

        self.entry_username = etk.Entry(text="")
        self.entry_username.on_text_activated(self._on_ok_clicked)
        self.entry_username.show()

        self.entry_password = etk.Entry(text="")
        self.entry_password.on_text_activated(self._on_ok_clicked)
        self.entry_password.show()
        self.entry_password.password_mode_set(1)

        vbox = etk.VBox()
        vbox.border_width_set(5)
        vbox.append(label_username, etk.VBox.START, etk.VBox.FILL, 5)
        vbox.append(self.entry_username, etk.VBox.START, etk.VBox.FILL, 10)

        vbox.append(label_password, etk.VBox.START, etk.VBox.FILL, 5)
        vbox.append(self.entry_password, etk.VBox.START, etk.VBox.FILL, 10)
        vbox.show()

        self.set_content(vbox)


class BonjourInfoModal(PanelContentModal):
    def __init__(self, parent, title, theme=None, hborder=16, vborder=50):
        PanelContentModal.__init__(self, parent, title, theme,
                                hborder=hborder, vborder=vborder)

        label_firstname = etk.Label('First name:')
        label_firstname.alignment_set(0.0, 1.0)
        label_firstname.show()

        label_lastname = etk.Label("Last name:")
        label_lastname.alignment_set(0.0, 1.0)
        label_lastname.show()

        label_nickname = etk.Label("Nickname:")
        label_nickname.alignment_set(0.0, 1.0)
        label_nickname.show()

        self.entry_firstname = etk.Entry(text="")
        self.entry_firstname.on_text_activated(self._on_ok_clicked)
        self.entry_firstname.show()

        self.entry_lastname = etk.Entry(text="")
        self.entry_lastname.on_text_activated(self._on_ok_clicked)
        self.entry_lastname.show()

        self.entry_nickname = etk.Entry(text="")
        self.entry_nickname.on_text_activated(self._on_ok_clicked)
        self.entry_nickname.show()

        vbox = etk.VBox()
        vbox.border_width_set(5)
        vbox.append(label_firstname, etk.VBox.START, etk.VBox.FILL, 5)
        vbox.append(self.entry_firstname, etk.VBox.START, etk.VBox.FILL, 10)

        vbox.append(label_lastname, etk.VBox.START, etk.VBox.FILL, 5)
        vbox.append(self.entry_lastname, etk.VBox.START, etk.VBox.FILL, 10)

        vbox.append(label_nickname, etk.VBox.START, etk.VBox.FILL, 5)
        vbox.append(self.entry_nickname, etk.VBox.START, etk.VBox.FILL, 10)
        vbox.show()

        self.set_content(vbox)

    def get_firstname(self):
        return self.entry_firstname.text

    def set_firstname(self, text):
        self.entry_firstname.text = text

    firstname = property(get_firstname, set_firstname)

    def get_lastname(self):
        return self.entry_lastname.text

    def set_lastname(self, text):
        self.entry_lastname.text = text

    lastname = property(get_lastname, set_lastname)

    def get_nickname(self):
        return self.entry_nickname.text

    def set_nickname(self, text):
        self.entry_nickname.text = text

    nickname = property(get_nickname, set_nickname)

    def _on_ok_clicked(self, *ignored):
        if self.callback_ok_clicked:
            self.callback_ok_clicked()

class ProtocolUserPassController(ModalController):
    terra_type = "Controller/Options/Folder/Apps/IM/AddAccount/LoginInfo"

    def __init__(self, model, canvas, parent):
        ModalController.__init__(self, model, canvas, parent)
        self.parent_controller = parent
        self.model = model
        self.protocol = self.model.name
        self.title = "%s login info" % self.protocol
        self.view = LoginPasswordModal(self.protocol,
                                       parent.last_panel,
                                       self.title,
                                       vborder=50)

        self.view.callback_ok_clicked = self._on_ok_clicked
        self.view.callback_cancel_clicked = self._on_cancel_clicked
        self.view.callback_escape = self._on_cancel_clicked
        self.view.callback_animate_finished = self.view.entry_username.focus
        self.view.show()

    def _reset_view(self):
        v = self.view
        v.title = self.title
        v.label.text = ""
        v.contents_set(v.modal_contents.object)
        v.modal_contents.show()
        v.modal_contents.frame.show()
        v.modal_contents.button_box.show()
        v.focus = True
        v.show()

    def _on_ok_clicked(self):
        self.view.username = self.view.username.strip()

        log.debug("Username: %s  Password: %s" %
                (self.view.username, "*" * len(self.view.password)))

        def errormsg(msg):
            def cb(*ig):
                msgmodal.hide(end_callback=self.view.entry_username.focus)
            msg = "".join(['<center>%s</center>' % m \
                            for m in textwrap.wrap(msg, 25)])
            msgmodal = MessageModal(self.parent_controller.last_panel, '', '')
            msgmodal.message(msg)
            msgmodal.show()
            ecore.timer_add(2.0, cb)

        if not self.view.username:
            errormsg("Username can't be empty!")
            return

        if not self.view.password:
            errormsg("Password can't be empty!")
            return

        try:
            account = Account(self.protocol,
                            self.view.username,
                            self.view.password)
        except Exception , e:
            errormsg(str(e))
            return

        def login_ok():
            def cb_close(*ignored):
                def cb_back(*ignored):
                    self.back()
                    self.parent.back()
                self.view.hide(end_callback=cb_back)

                if not be.add_account(account):
                    return

                MainModelFolder = self.parent.screen_controller.model
                MainModelFolder._create_model_from_account(account)
                self.parent.screen_controller.view.bottom_message_show(
                    "Click and hold to connect", 5)

            def cb(*ignore):
                account.disconnect(cb_close)

            self.view.message("Login successful!")

            ecore.timer_add(1.5, cb)

        def login_failed(account, error):
            def cb():
                self.view.hide(end_callback=self._reset_view)

            error = "Login failed: " + error
            error = "".join(['<center>%s</center>' % m \
                            for m in textwrap.wrap(error, 25)])
            self.view.message(error)
            ecore.timer_add(1.5, cb)

        self.view.message_wait("Checking login...")
        account.connect(login_ok, login_failed, test=True)

    def _on_cancel_clicked(self):
        def cb(*ignored):
            self.back()
        self.view.hide(end_callback=cb)

    def delete(self):
        self.view.delete()
        self.view = None
        self.model = None


class BonjourInfoController(ProtocolUserPassController):
    terra_type = "Controller/Options/Folder/Apps/IM/AddAccount/BonjourInfo"

    def __init__(self, model, canvas, parent):
        ModalController.__init__(self, model, canvas, parent)
        self.parent_controller = parent
        self.model = model
        self.title = "Bonjour login info"
        self.view = BonjourInfoModal(parent.last_panel,
                                     self.title,
                                     vborder=50)

        self.view.callback_ok_clicked = self._on_ok_clicked
        self.view.callback_cancel_clicked = self._on_cancel_clicked
        self.view.callback_escape = self._on_cancel_clicked
        self.view.callback_animate_finished = self.view.entry_firstname.focus
        self.view.show()

    def _on_ok_clicked(self):
        self.view.firstname = self.view.firstname.strip()
        self.view.lastname = self.view.lastname.strip()
        self.view.nickname = self.view.nickname.strip()

        def errormsg(msg):
            def cb(*ig):
                msgmodal.hide(end_callback=self.view.entry_firstname.focus)
            msg = "".join(['<center>%s</center>' % m \
                            for m in textwrap.wrap(msg, 25)])
            msgmodal = MessageModal(self.parent_controller.last_panel, '', '')
            msgmodal.message(msg)
            msgmodal.show()
            ecore.timer_add(3.0, cb)

        if not self.view.firstname or not self.view.lastname \
           or not self.view.nickname:
            errormsg("You have to provide first, last and nick names!")
            return

        try:
            account = BonjourAccount(self.view.firstname,
                                     self.view.lastname,
                                     self.view.nickname)
        except Exception , e:
            errormsg(str(e))
            return

        def cb_close(*ignored):
            def cb_back(*ignored):
                self.back()
                self.parent.back()
            self.view.hide(end_callback=cb_back)

        self.view.message("Account added!")
        self.view.half_expand()
        ecore.timer_add(1.5, cb_close)

        if not be.add_account(account):
            self.view.message("Account already in list")
            return

        MainModelFolder = self.parent.screen_controller.model
        MainModelFolder._create_model_from_account(account)
        self.parent.screen_controller.view.bottom_message_show(
            "Click and hold to connect", 5)


class AddAccountOptionsFolderController(ListPanelController):
    terra_type = "Controller/Options/Folder/Apps/IM/AddAccount"

    def _setup_view(self):
        title = self.model.name
        self.view = OptionsHeaderFolderPanel(self.parent.window, title,
                                            self.model.header_text,
                                            self.model.children)
        self.view.callback_clicked = self.cb_on_clicked
        self.view.callback_escape = self.back


class AccountOptionsFolderController(ListPanelController):
    terra_type = "Controller/Options/Folder/Apps/IM/Account/Options"

    def cb_on_clicked(self, view, index):
        ListPanelController.cb_on_clicked(self, view, index)
        self.model.notify_status_changed = self.parent.back
        self.model.notify_order_changed = self.parent.back


class SetStatusOptionsFolderController(ListPanelController):
    terra_type = "Controller/Options/Folder/Apps/IM/Account/Options/SetStatus"

    def cb_on_clicked(self, view, index):
        model = self.model.children[index]

        def cb_close(*ignore):
            entrymsg.hide()
            self.back(self.parent.model.notify_status_changed)

        def cb(msg):
            be.set_global_status(model.status, msg)
            dlgmsg = "Status set to '%s'" % model.name
            dlgmsg = "".join(['<center>%s</center>' % m \
                            for m in textwrap.wrap(dlgmsg, 25)])
            entrymsg.message(dlgmsg)
            ecore.timer_add(1.5, cb_close)

        entrymsg = EntryModal(self, "Status message",
            "Enter status message:", value=be.status_message)
        if model.status == 'offline':
            entrymsg.show()
            cb('')
        else:
            entrymsg.callback_ok_clicked = cb
            entrymsg.callback_cancel_clicked = cb_close
            entrymsg.callback_animate_finished = entrymsg.entry.focus
            entrymsg.show()


class SetOrderOptionsFolderController(ListPanelController):
    terra_type = "Controller/Options/Folder/Apps/IM/Account/Options/SetOrder"

    def cb_on_clicked(self, view, index):
        model = self.model.children[index]
        if model.name == "by name":
            self.parent.screen_controller.model.children_sort_by_name()
        elif model.name == "by status":
            self.parent.screen_controller.model.children_sort_by_status()
        self.back(self.parent.model.notify_order_changed)
