# Canola2 IM Plugin
# Authors: Thiago Borges Abdnur <bolaum@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import pdb

import os
import logging

import sqlite3

from terra.core.manager import Manager
from terra.core.singleton import Singleton

manager = Manager()

log = logging.getLogger("plugins.canola-im.db")

class IMDataBase(Singleton):
    _db = manager.canola_db

    def __init__(self):
        Singleton.__init__(self)
        create_accounts_stmt = "CREATE TABLE IF NOT EXISTS im_accounts (" \
                               "protocol TEXT, " \
                               "username TEXT, " \
                               "password TEXT, " \
                               "PRIMARY KEY(protocol, username) )"

        create_options_stmt = "CREATE TABLE IF NOT EXISTS im_options (" \
                              "option TEXT, " \
                              "value TEXT, " \
                              "PRIMARY KEY(option) )"

        create_avatars_stmt = "CREATE TABLE IF NOT EXISTS im_avatars (" \
                              "manager TEXT, " \
                              "protocol TEXT, " \
                              "token TEXT, " \
                              "user TEXT, " \
                              "path TEXT, " \
                              "last_used DATE, " \
                              "PRIMARY KEY(manager, protocol, token) )"
        try:
            self._db.execute(create_accounts_stmt)
            self._db.execute(create_options_stmt)
            self._db.execute(create_avatars_stmt)
        except sqlite3.OperationalError, e:
            log.error("Error when creating im tables: %s" % e)
        self.set_default_options()
        self.commit()

    def set_default_options(self):
        default_options = { 'last_status' : 'available',
                            'last_status_message' : '' }
        search_stmt = "SELECT option FROM im_options"
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            log.error("table 'im_options' doesn't exist")
        for option in default_options.keys():
            if (option,) not in data:
                insert_stmt = "INSERT INTO im_options VALUES (" \
                          "'%s', '%s' )" % (option, default_options[option])
                self._db.execute(insert_stmt)

    def commit(self):
        self._db.commit()

    def get_accounts(self):
        search_stmt = "SELECT * FROM im_accounts"
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            log.error("table 'im_accounts' doesn't exist")
        return data

    def _already_in(self, protocol, username):
        search_stmt = "SELECT * FROM im_accounts WHERE protocol = '%s'" \
                      "AND username = '%s'" % (protocol, username)
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            log.error("table 'im_accounts' doesn't exist")
        return bool(data)

    def add_account(self, account, replace=True):
        protocol = account.protocol_ref
        password = account.password

        if protocol == 'Bonjour':
            username = "%s#%s#%s" \
                % (account.firstname, account.lastname, account.nickname)
        else:
            username = account.username

        if replace:
            replace_stmt = "REPLACE INTO im_accounts VALUES (" \
                          "'%s', '%s', '%s' )" % (protocol, username, password)
            self._db.execute(replace_stmt)
            return True
        if self._already_in(protocol, username):
            log.warn("Account already in db")
            return False
        else:
            insert_stmt = "INSERT INTO im_accounts VALUES (" \
                          "'%s', '%s', '%s' )" % (protocol, username, password)
            self._db.execute(insert_stmt)
            return True

    def remove_account(self, account):
        protocol = account.protocol_ref
        if protocol == 'Bonjour':
            username = "%s#%s#%s" \
                % (account.firstname, account.lastname, account.nickname)
        else:
            username = account.username

        delete_stmt = "DELETE FROM im_accounts WHERE protocol = '%s'" \
                      "AND username = '%s'" % (protocol, username)
        self._db.execute(delete_stmt)

    def set_option(self, option, value):
        replace_stmt = "REPLACE INTO im_options VALUES (" \
                       "'%s', '%s' )" % (option, value)
        self._db.execute(replace_stmt)
        self.commit()

    def get_option(self, option):
        search_stmt = "SELECT value FROM im_options WHERE option = " \
                      "'%s'" % (option)
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            data = None
            log.error("table 'im_options' doesn't exist")
        if data:
            return data[0][0]
        else:
            return None

    def set_account_option(self, account, option, value):
        n_option = "%s_%s_%s" % \
            (account.protocol_ref, account.username, option)
        self.set_option(n_option, value)

    def get_account_option(self, account, option):
        n_option = "%s_%s_%s" % \
            (account.protocol_ref, account.username, option)
        return self.get_option(n_option)

    def add_avatar(self, contact, token, path):
        if not contact.parent:
            return False
        manager = contact.parent.manager
        protocol = contact.parent.protocol
        user = contact.id
        replace_stmt = "REPLACE INTO im_avatars VALUES (" \
                       "'%s', '%s', '%s', '%s', '%s', " \
                       "strftime('%%s','now') )" \
                       % (manager, protocol, token, user, path)
        self._db.execute(replace_stmt)
        return True

    def remove_avatar_by_path(self, path):
        if not path:
            return
        log.debug("Removing avatar: %s" % path)
        delete_stmt = "DELETE FROM im_avatars WHERE path = '%s'" % path
        try:
            self._db.execute(delete_stmt)
        except sqlite3.OperationalError, e:
            pass

    def get_avatar_by_token(self, contact, token):
        if not contact.parent:
            return None
        manager = contact.parent.manager
        protocol = contact.parent.protocol
        search_stmt = "SELECT path FROM im_avatars WHERE " \
                      "manager = '%s' AND protocol = '%s' AND token = '%s'" \
                      % (manager, protocol, token)
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            data = None
            log.error("table 'im_avatars' doesn't exist")
        if data:
            return data[0][0]
        else:
            return None

    def get_avatar_by_user(self, contact):
        # Returns the most recently avatar used by contact (token, path)
        if not contact.parent:
            return None
        manager = contact.parent.manager
        protocol = contact.parent.protocol
        user = contact.id
        search_stmt = "SELECT token, path FROM im_avatars WHERE " \
                      "manager = '%s' AND protocol = '%s' AND user = '%s' " \
                      "ORDER BY last_used DESC" \
                      % (manager, protocol, user)
        try:
            data = self._db.execute(search_stmt)
        except sqlite3.OperationalError, e:
            data = None
            log.error("table 'im_avatars' doesn't exist")
        if data:
            return data[0]
        else:
            return None, None
