#!/usr/bin/env python2.5
#
# helper functions
#

import os, re, dircache

from UserDict import UserDict

def search_files(dir, pattern):
    filenames = []
    if os.path.exists(dir):
        files   = dircache.listdir(dir)
        pat     = re.compile(pattern)
        file_string = ''.join(files)
        for match in pat.finditer(file_string):
            filenames.append(os.path.join(dir, match.group(0)))

    return filenames

def attributesFromDict(d, obj=None, objName="self"):
    '''see http://code.activestate.com/recipes/280381/'''
    if obj is None:
        obj = d.pop(objName)
    for n, v in d.iteritems():
        setattr(obj, n, v)

class Xlator(UserDict):
    """ An all-in-one multiple string substitution class,
    see http://code.activestate.com/recipes/81330/ """

    def _make_regex(self):
        """ Build a regular expression object based on the keys of
        the current dictionary """

        regex = "(%s)" % "|".join(map(re.escape, self.keys()))
        return re.compile(regex)

    def __call__(self, mo):
        """ This handler will be invoked for each regex match """

        # Count substitutions
        self.count += 1 # Look-up string

        return self[mo.string[mo.start():mo.end()]]

    def xlat(self, text):
        """ Translate text, returns the modified text. """
        # Reset substitution counter
        self.count = 0

        # Process text
        return self._make_regex().sub(self, text)

