#
# classes and functions to use the flickr api 
#

import sqlite3
import flickr, helper

DB="flickrcache.db"

class FlickrDB(flickr.Flickr):
    def __init__(self, username="", offline=False, aplication="canola-flickr"):
        flickr.Flickr.__init__(self, username)

        self.offline        = offline
        self.application    = application

        # setup database
        self.db_conn = sqlite3.connect(DB)
        self.db_conn.text_factory = str
        self.db = self.db_conn.cursor()

    def login(self):
        if not self.offline:
            result = flickr.Flickr.login()

            # save status in cache
            self.cache_add_status()

            return result
        else:
            return self.cache_get_status()

    def _cache_create_status(self):
        self.db.execute('CREATE TABLE status (application TEXT PRIMARY KEY, last_user TEXT, logged_in INTEGER)')
        self.db_conn.commit()

    def _cache_create_users(self):
        self.db.execute('CREATE TABLE users (nsid TEXT PRIMARY KEY, username TEXT)')
        self.db_conn.commit()

    def _cache_create_photosets(self):
        self.db.execute('CREATE TABLE photosets (id INTEGER PRIMARY KEY, user_id TEXT, sort_id INTEGER, title TEXT, description TEXT, photos INTEGER)')
        self.db_conn.commit()

    def _cache_create_photoset_photos(self):
        self.db.execute('CREATE TABLE photoset_photos (id integer AUTO_INCREMENT PRIMARY KEY,  photoset_id INTEGER, photo_id INTEGR, sort_id INTEGER)')
        self.db_conn.commit()

    def _cache_create_photos(self):
        self.db.execute('CREATE TABLE photos (id INTEGER PRIMARY KEY, secret TEXT, title TEXT, description TEXT)')
        self.db_conn.commit()

    def cache_add_status(self):
        return True

    def cache_get_status(self):
        try:
            db_cursor = self.db.execute('SELECT last_user, logged_in FROM status WHERE application = ? LIMIT 1', (self.application,))
            db_status = db.cursor.fetchone()

            last_user = db_status[0]
            logged_in = db_status[1]

            if self.logged_in == 1: self.logged = True
            else: self.logged = False

            self.user = self.cache_get_user(last_user)

        except sqlite3.DatabaseError:
            try:
                self._cache_create_status()
            except sqlite3.OperationalError:
                pass

        return self.logged

    def cache_get_photosets(self, user_id):
        photosets = []
        try:
            db_photosets = self.db.execute('SELECT id, title, description, photos FROM photosets WHERE user_id = ? ORDER BY sort_id', (user_id,))

            for photoset in db_photosets:
                id          = photoset[0]
                title       = photoset[1]
                description = photoset[2]
                photos      = photoset[3]
                photosets.append(flickr.Photoset(id=id, title=title, description=description, photos=photos))

        except sqlite3.DatabaseError:
            try:
                self._cache_create_photosets()
            except sqlite3.OperationalError:
                pass

        return photosets

    def cache_get_photos(self, photo_ids):
        photos = []

        for photo_id in photo_ids:
            try:
                db_cursor = self.db.execute('SELECT id, secret, title, description FROM photos WHERE id = (?) LIMIT 1', (photo_id,))
                db_photo = db_cursor.fetchone()

                id          = db_photo[0]
                secret      = db_photo[1]
                title       = db_photo[2]
                description = db_photo[3]
                photos.append(flickr.Photo(id=id, secret=secret, title=title, description=description))

            except sqlite3.DatabaseError:
                try:
                    self._cache_create_photos()
                except sqlite3.OperationalError:
                    pass

        return photos

    def cache_add_photosets(self, photosets, user_id):
        if len(photosets) == 0: return True

        # clean photoset cache for this user_id, create db table, if we get an OperationalError
        try:
            self.db.execute('DELETE FROM photosets WHERE user_id = ?', (user_id,))
        except sqlite3.OperationalError:
            self._cache_create_photosets()

        sort_id = 1
        for photoset in photosets:
            id          = photoset.id
            title       = photoset.title
            description = photoset.description
            photos      = photoset.photos

            tuple = (id, user_id, sort_id, title, description, photos)
            self.db.execute('INSERT INTO photosets VALUES(?,?,?,?,?,?)', tuple)
            sort_id = sort_id + 1

        self.db_conn.commit()
        return True

    def cache_add_photos_photoset(self, photoset, photos):
        if len(photos) == 0: return True

        # clean cache for this photoset_id, create db table, if we get an OperationalError
        try:
            self.db.execute('DELETE FROM photoset_photos WHERE photoset_id = ?', (photoset.id,))
        except sqlite3.OperationalError:
            self._cache_create_photoset_photos()

        sort_id = 1
        for photo in photos:
            tuple = (photoset.id, photo.id, sort_id)
            self.db.execute('INSERT INTO photoset_photos (photoset_id, photo_id, sort_id) VALUES(?,?,?)', tuple)
            sort_id = sort_id + 1

        self.db_conn.commit()
        return True

    def cache_get_photos_photoset(self, photoset):
        photo_ids = []
        print "photoset: %s" % photoset
        try:
            db_photo_ids = self.db.execute('SELECT photo_id FROM photoset_photos WHERE photoset_id = ? ORDER BY sort_id', (photoset.id,))
            for id in db_photo_ids:
                photo_ids.append(str(id[0]))
            return self.cache_get_photos(photo_ids)
        except sqlite3.OperationalError:
            self._cache_create_photoset_photos()
            return []

    def cache_add_photos(self, photos):
        if len(photos) == 0: return True

        for photo in photos:
            id          = photo.id
            title       = photo.title
            description = photo.description
            secret      = photo.secret

            # clean photo cache for this photo, create db table, if we get an OperationalError
            try:
                self.db.execute('DELETE FROM photos WHERE id = ?', (id,))
            except sqlite3.OperationalError:
                self._cache_create_photos()

            tuple = (id, secret, title, description)
            self.db.execute('INSERT INTO photos VALUES(?,?,?,?)', tuple)
            self.db_conn.commit()

        return True

def main():
    flickr = FlickrDB(offline=True)

    res = flickr.login()
    if not res == True:
        raw_input("Please switch to your browser window and permit Canola-Flickr access to your flickr account!")
        res = flickr.login()
        if not res == True:
            print "Error, could not get access to a flickr account!"
            return -1

    user_id = flickr.user.nsid
    #print "User: %s" % user_id

    #photosets_db = flickr.cache_get_photosets(user_id)
    #print "photosets (cache):\t%s" % len(photosets_db)
   
    #photosets_api = flickr.get_photosets()
    #print "photosets (api):\t%s" % len(photosets_api)

    #flickr.cache_add_photosets(photosets=photosets_api, user_id=user_id) 

    photosets_db = flickr.cache_get_photosets(user_id)
    print "photosets (cache):\t%s" % len(photosets_db)
   
    #for photoset in photosets_db:
    #    print photoset

    #photos = flickr.get_photos_photoset(photoset=photosets_db[0])
    photos = flickr.cache_get_photos_photoset(photoset=photosets_db[0])
    #flickr.cache_add_photos(photos)
    #flickr.cache_add_photos_photoset(photosets_db[0], photos)

    print "photos (cache): %s" % len(photos)

    for photo in photos:
        print photo

    return 0

if __name__ == "__main__":
    import sys
    sys.exit(main())

