# Canola2 Flickr Plugin
# Copyright (C) 2008 Thomas Schmidt <tschmidt@debian.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import evas
import ecore
import locale
import logging

from terra.core.manager import Manager

from model import SearchModelFolder, MainModelFolder

manager = Manager()
CanolaError = manager.get_class("Model/Notify/Error")
BaseListController = manager.get_class("Controller/Folder")
ModalController = manager.get_class("Controller/Modal")
EntryDialogModel = manager.get_class("Model/EntryDialog")
OptionsControllerMixin = manager.get_class("OptionsControllerMixin")

log = logging.getLogger("plugins.canola-flickr.ui")

class ListController(BaseListController, OptionsControllerMixin):
    """Flickr Navigation List.

    This is the initial list of Flickr plugin. It shows all navigation
    possibilities, like Search for videos, Bookmarks, History, Most Viewed,
    Most Recent, Top Rated, ...

    This list is identical to Canola Text List, with a special treatment for
    the Search item, that popup a Search Modal before go to the next screen.

    @see: BaseListController
    """
    terra_type = "Controller/Folder/Task/Image/Flickr"

    def __init__(self, model, canvas, parent):
        BaseListController.__init__(self, model, canvas, parent)
        OptionsControllerMixin.__init__(self)
        self.model.callback_info = self.cb_info
        self.model.callback_notify = self.cb_notify

        width, height = canvas.size

    def cb_info(self, msg):
        """Display a message in the screen."""
        self.view.part_text_set("message", msg)

    def cb_notify(self, err):
        """Display a message in a notify window."""
        self.parent.show_notify(err)

    def cb_on_clicked(self, view, index):
        model = self.model.children[index]

        if type(model) is not SearchModelFolder:
            BaseListController.cb_on_clicked(self, view, index)
            return

        def do_search(ignored, text):
            if text is not None:
                model.query = text
                BaseListController.cb_on_clicked(self, view, index)

        dialog = EntryDialogModel("Search for tags", "Enter keywords or tags:",
                                  answer_callback=do_search)
        self.parent.show_notify(dialog)

    def delete(self):
        self.model.callback_info = None
        self.model.callback_notify = None
        OptionsControllerMixin.delete(self)
        BaseListController.delete(self)

class ModalMessageController(ModalController):
    terra_type = "Controller/Modal"

    def __init__(self, model, canvas, parent, message):
        ModalController.__init__(self, model, canvas, parent)

        self.view = ModalMessage(parent.last_panel.view,
                                 message, hborder=60, vborder=120)
        self.callback_leave = None
        self.view.callback_escape = self.close
        self.view.callback_clicked = self.close
        self.view.show()

    def close(self):
        def cb(*ignored):
            self.back(self.callback_leave)
        self.view.hide(end_callback=cb)

    def delete(self):
        self.view.delete()

