#!/bin/sh

# Do nothing if current shell is not /bin/sh;
# Unfortunately, terminal does not set SHELL
getent passwd | grep -q "^$USER:.*:/bin/sh$" || continue

# Do not run if user already has a ~/.bashrc AND if it does not
# contain the line:
#
# ~/.bashrc: executed by bash(1) for non-login shells
#
# The reason for this exception is that by default the flash ROM image
# contains a leftover ~/.bashrc which contains this incorrect assertion.
if [ -f ~/.bashrc ]; then
    if ! head -1 ~/.bashrc | grep -q "for non-login shells"; then
        continue
    fi
fi

bash-setup.sh
